import React from 'react';
import { CommandCompleteEvent, KResponse } from '@kui-shell/core';
import { Maximizable } from '../../Views/Sidecar/width';
import LocationProps from '../../Views/Sidecar/Location';
import { BlockViewTraits } from '../../Views/Terminal/Block';
declare type Props = Maximizable & BlockViewTraits & LocationProps & {
    response: KResponse | Error;
    completeEvent?: CommandCompleteEvent;
    onRender?: (hasContent: boolean) => void;
    willRemove?: () => void;
    willUpdateCommand?: (command: string) => void;
};
interface State {
    catastrophicError: Error;
}
/**
 * Component that renders a "ScalarResponse", which is a command
 * response that doesn't require any particularly special
 * interpretation or visualization of the inner structure --- i.e. a
 * response that is suitable for rendering directly in the Terminal.
 *
 */
export default class Scalar extends React.PureComponent<Props, State> {
    constructor(props: Props);
    static getDerivedStateFromProps(): {
        catastrophicError: any;
    };
    static getDerivedStateFromError(error: any): {
        catastrophicError: any;
    };
    componentDidCatch(error: Error, errorInfo: React.ErrorInfo): void;
    private onRender;
    private readonly _onRender;
    private renderResponse;
    render(): any;
}
export {};
