/*
 * Copyright 2020 The Kubernetes Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
import React from 'react';
import { Accordion, AccordionItem, AccordionToggle, AccordionContent } from '@patternfly/react-core';
import { eventBus, getPrimaryTabId, i18n } from '@kui-shell/core';
import '../../../../../web/scss/components/Accordion/PatternFly.scss';
const strings = i18n('plugin-client-common');
export default class PatternFlyAccordion extends React.PureComponent {
    constructor(props) {
        super(props);
        this.state = {
            expandedIdx: -1
        };
    }
    content(idx) {
        const isHidden = this.state.expandedIdx !== idx;
        return React.createElement(AccordionContent, { isHidden: isHidden }, !isHidden && this.props.content[idx]());
    }
    render() {
        return (React.createElement(Accordion, { asDefinitionList: false, className: `kui--accordion ${this.props.isWidthConstrained ? 'flex-fill' : ''}` }, this.props.names.map((name, idx) => (React.createElement("div", { key: idx, className: "kui--accordion-item" },
            React.createElement(AccordionItem, null,
                React.createElement(AccordionToggle, { id: idx.toString(), onClick: () => {
                        this.setState(curState => ({ expandedIdx: curState.expandedIdx !== idx ? idx : -1 }));
                        eventBus.emitTabLayoutChange(getPrimaryTabId(this.props.tab));
                    }, isExpanded: this.state.expandedIdx === idx }, this.state.expandedIdx !== idx ? strings('Show X', name) : strings('Hide X', name)),
                this.content(idx)))))));
    }
}
//# sourceMappingURL=PatternFly.js.map