/*
 * Copyright 2020 The Kubernetes Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
import React from 'react';
import { Dropdown, DropdownItem, DropdownSeparator, KebabToggle, DropdownToggle } from '@patternfly/react-core';
import Icons from '../../Icons';
import CaretUpIcon from '@patternfly/react-icons/dist/js/icons/caret-down-icon';
import '../../../../../web/scss/components/DropDown/PatternFly.scss';
export default class PatternFlyDropDown extends React.PureComponent {
    constructor() {
        super(...arguments);
        this._onToggle = this.onToggle.bind(this);
        this._onSelect = this.onSelect.bind(this);
    }
    renderDropDownItems(actions) {
        const renderItems = [];
        actions.forEach(item => {
            if (item.hasDivider) {
                renderItems.push(React.createElement(DropdownSeparator, { key: "separator" }));
            }
            renderItems.push(React.createElement(DropdownItem, { key: item.label, component: "button", className: "kui--dropdown__menu-item", "data-mode": item.label },
                React.createElement("span", { className: "small-right-pad", style: !item.isSelected ? { opacity: 0 } : undefined },
                    React.createElement(Icons, { icon: "Checkmark", "data-mode": "selected container" })),
                item.label));
        });
        return renderItems;
    }
    onToggle(isOpen) {
        this.setState({ isOpen });
    }
    onSelect(evt) {
        const selectedItemLabel = evt.target.getAttribute('data-mode');
        const selectedItem = this.props.actions.find(_ => _.label === selectedItemLabel);
        if (selectedItem) {
            const currentSelectedItem = this.props.actions.find(_ => _.isSelected);
            if (currentSelectedItem) {
                currentSelectedItem.isSelected = false;
            }
            selectedItem.isSelected = true;
            setTimeout(() => selectedItem.handler());
        }
        else {
            console.error('Internal error: could not find item model for selected item', evt.target, this.props.actions);
        }
        this.setState(curState => ({ isOpen: !curState.isOpen }));
        if (this.props.onClose) {
            this.props.onClose();
        }
    }
    /** @return the label for the entire caret-style Dropdown */
    currentLabel() {
        const currentItem = this.props.actions.find(_ => _.isSelected);
        return currentItem ? currentItem.label : '';
    }
    render() {
        if (this.props.actions.length === 0) {
            return React.createElement(React.Fragment, null);
        }
        return (React.createElement(Dropdown, { title: this.props.title, className: 'kui--dropdown ' + (this.props.className || ''), onSelect: this._onSelect, isPlain: this.props.isPlain, toggle: !this.props.toggle || this.props.toggle === 'kebab' ? (React.createElement(KebabToggle, { className: "kui--dropdown__toggle", onToggle: this._onToggle })) : (React.createElement(DropdownToggle, { className: "kui--dropdown__toggle", onToggle: this._onToggle, toggleIndicator: CaretUpIcon, icon: this.props.icon }, this.currentLabel())), isOpen: this.state && this.state.isOpen, dropdownItems: this.renderDropDownItems(this.props.actions), direction: this.props.direction, position: this.props.position || 'right' }));
    }
}
//# sourceMappingURL=PatternFly.js.map