import React from 'react';
export interface TabConfiguration {
    topTabNames?: 'command' | 'fixed';
    title?: string;
}
declare type Props = TabConfiguration & {
    idx: number;
    uuid: string;
    active: boolean;
    closeable: boolean;
    onCloseTab: (idx: number) => void;
    onSwitchTab: (idx: number) => void;
};
interface State {
    title: string;
    processing: boolean;
    isFreshlyCreated: boolean;
    topTabNames: 'command' | 'fixed';
}
export default class Tab extends React.PureComponent<Props, State> {
    private readonly closeTabRef;
    private onCommandStart;
    private onCommandComplete;
    private onThemeChange;
    constructor(props: Props);
    componentWillUnmount(): void;
    private removeCommandEvaluationListeners;
    /**
     * Register any command evaluation listeners, i.e. when the REPL finishes evaluating a command.
     *
     */
    private addCommandEvaluationListeners;
    private isUsingCommandName;
    render(): JSX.Element;
}
export {};
