import KuiConfiguration from './KuiConfiguration';
/** The type of the handler for listeners to changes to user settings overrides */
declare type ChangeHandler = (evt: 'set' | 'reset' | 'unset') => void;
/** Responding to a change in user settings overrides */
export declare function on(handler: ChangeHandler): void;
/** Stop responding to a change in user settings overrides */
export declare function off(handler: ChangeHandler): void;
/** Respond once to a change in user settings overrides */
export declare function once(handler: ChangeHandler): void;
/** @return Any user overrides of the base KuiConfiguration */
export default function load(): KuiConfiguration;
/** Read out one user setting */
export declare function get<K extends keyof KuiConfiguration>(key: K): KuiConfiguration[K];
/** Update one user setting */
export declare function set<K extends keyof KuiConfiguration>(key: K, value: KuiConfiguration[K]): void;
/** Remove one user setting */
export declare function unset<K extends keyof KuiConfiguration>(key: K): void;
/** Remove all user settings */
export declare function reset<K extends keyof KuiConfiguration>(): void;
export {};
