import React from 'react';
import { CompletionResponse } from '@kui-shell/core';
import { InputProvider as Input } from './Input';
import '../../../../../web/css/static/TabCompletion.scss';
/** User has typed `partial`, and we have `completions` to offer them. */
interface Completions {
    partial: string;
    shellEscapeNotNeeded?: boolean;
    completions: CompletionResponse[];
}
/**
 * Abstract base class to manage Tab Completion state. This includes
 * asynchronously enumerating the `completions` from a starting
 * `partial. Subclasses will handle both rendering of completion
 * results, and also will direct state transitions.
 *
 */
export declare abstract class TabCompletionState {
    protected readonly input: Input;
    private currentEnumeratorAsync;
    protected readonly lastIdx: number;
    constructor(input: Input);
    private findCommandCompletions;
    protected findCompletions(lastIdx?: number): Promise<Completions>;
    /** User has typed another key, while a tab completion is active */
    key(event: KeyboardEvent): void;
    /** Perform a state update to reflect the new set of Completions. */
    protected update(spec: Completions, prefillPartialMatches: boolean): void;
    /** Is the new set of Completions worth a re-render? */
    protected willUpdate(completions: Completions, prefillPartialMatches: boolean): boolean;
    /**
     * Respond to additional input.
     *
     * @param prefillPartialMatches Update the prompt with partial matches?
     */
    private again;
    /** Terminate this tab completion */
    done(): void;
    abstract render(): false | React.ReactElement;
}
/**
 * User has hit Tab in an Input component. Should we initialize a tab completion state?
 *
 */
export default function startTabCompletion(input: Input, evt: KeyboardEvent): void;
export {};
