/// <reference types="node" />
import React from 'react';
import { ScalarResponse, Tab as KuiTab, CommandStartEvent, CommandCompleteEvent, Notebook } from '@kui-shell/core';
import ScrollbackState from './ScrollbackState';
import KuiConfiguration from '../../Client/KuiConfiguration';
import '../../../../web/scss/components/Terminal/_index.scss';
export interface TerminalOptions {
    noActiveInput?: boolean;
}
declare type Props = TerminalOptions & {
    /** tab UUID */
    uuid: string;
    /** tab model */
    tab: KuiTab;
    snapshot?: Buffer;
    tabTitle?: string;
    /** handler for terminal clear */
    onClear?: () => void;
    /** KuiConfiguration */
    config: KuiConfiguration;
};
interface State {
    focusedIdx: number;
    splits: ScrollbackState[];
    notebookMetadata?: Notebook['metadata'];
}
/** get the selected texts in window */
export declare function getSelectionText(): string;
export default class ScrollableTerminal extends React.PureComponent<Props, State> {
    /**
     * For UUID generation, keep a running counter of the total number
     * of scrollbacks created. This index will be fed to the uuid.v5()
     * generator. Note: we can't use the scrollback's index in the
     * current split array, because the user might reorder them, e.g. by
     * creating two splits, then deleting the *first*, then creating
     * (again) a second split. What was the second split is now in the
     * first position, and the new split will have the same ID as the
     * (now) first-ordinal split. Thus, instead we keep a running
     * counter. This will preserve cross-session UUID sequence equality,
     * while avoiding the reordering dilemma.
     */
    private scrollbackCounter;
    private cleaners;
    constructor(props: Props);
    /** replay the splits and blocks from snapshot */
    private replaySnapshot;
    /** Listen for copy and paste (TODO: cut) events to facilitate moving blocks */
    private initClipboardEvents;
    /** Listen for snapshot request events */
    private initSnapshotEvents;
    /** add welcome blocks at the top of scrollback */
    private scrollbackWithWelcome;
    private allocateUUIDForScrollback;
    /** Restore from localStorage for a given tab UUID */
    private restoreBlocks;
    private scrollback;
    /** @return a reasonable default split */
    private findMainSplit;
    /** @return a reasonable default split */
    private get current();
    /** @return the uuid of a reasonable default split */
    private get currentUUID();
    /** Clear Terminal; TODO: also clear persisted state, when we have it */
    private clear;
    /**
     * For click handlers in minisplits, we want to direct the command
     * execution UI to a plain terminal, if that is possible.
     *
     * @return the sbuuid of a plain split, if the given split is a minisplit, and for a ClickHandler event
     *
     */
    private redirectToPlainSplitIfNeeded;
    /** the REPL started executing a command */
    onExecStart(uuid: string, asReplay: boolean, event: CommandStartEvent, insertIdx?: number): void;
    /** Format a MarkdownResponse */
    private markdown;
    /** the REPL finished executing a command */
    onExecEnd(uuid: string, asReplay: boolean, event: CommandCompleteEvent<ScalarResponse>, insertIdx?: number): Promise<void>;
    /** Only set focus if we haven't, yet */
    doFocusIfNeeded(): void;
    /** Owner wants us to focus on the current prompt */
    private _focusDebouncer;
    private doFocus;
    private setFocusOnScrollback;
    /**
     * Handle CommandStart/Complete events directed at the given
     * scrollback region.
     *
     */
    private hookIntoREPL;
    /**
     * Handle events directed at the given scrollback region.
     *
     */
    private initEvents;
    /** A controller has requested a tab layout modification */
    private onTabLayoutModificationRequest;
    /** Split the view */
    private onSplit;
    /** Detach hooks that might have been registered */
    private uninitEvents;
    componentWillUnmount(): void;
    /**
     * @return the index of the given scrollback, in the context of the
     * current (given) state
     *
     */
    findSplit(curState: State, uuid: string): number;
    /**
     * @return the index of the given scrollback, in the context of the
     * current (given) state
     *
     */
    private findAvailableSplit;
    /** If the block has watchable response, abort the job */
    private removeWatchableBlock;
    /** As per `removeWatchableBlock`, but for all blocks */
    private terminateAllWatchables;
    /**
     * Remove the given split (identified by `sbuuid`) from the state.
     *
     */
    private removeSplit;
    /**
     * Splice in an update to the given split (identified by `sbuuid`),
     * using the giving ScrollbackState mutator.
     *
     */
    private splice;
    /** Helper for splice; i.e. splice() does the setState, while this method does them mutate */
    private spliceMutate;
    /** whether the given scrollback has Active Block */
    private hasActiveBlock;
    /** return the index of the Active Block from a scrollback */
    private findActiveBlock;
    private isASideBySide;
    private tabFor;
    /**
     * This map keeps track of which split indices are minisplits. The
     * primary index is the current split count. That gives an array
     * which indicates whether the given scrollback index is a
     * minisplit.
     *
     * NOTE: minsplits are disable for now; see: https://github.com/kubernetes-sigs/kui/issues/7307
     */
    private readonly theseAreMiniSplits;
    /**
     * Same, but keeping track of when we have two splits arranged
     * horizontally side-by-side.
     *
     */
    private readonly theseAreSideBySide;
    /** Present the given scrollback as a minisplit? */
    private isMiniSplit;
    /** Is this scrollback not-100% width? */
    private isWidthConstrained;
    /** Render the blocks in one split */
    private blocks;
    /** Render one split */
    private split;
    render(): JSX.Element;
}
export {};
