/*
 * Copyright 2020 The Kubernetes Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
import { v4 } from 'uuid';
import { join } from 'path';
import { tmpdir } from 'os';
import { Common, CLI, ReplExpect, SidecarExpect, Util } from '@kui-shell/test';
import { setValue } from './common';
function expectText(res, expectedText) {
    let idx = 0;
    return res.app.client.waitUntil(() => __awaiter(this, void 0, void 0, function* () {
        const actualText = yield Util.getValueFromMonaco(res);
        if (++idx > 5) {
            console.error(`still waiting for actualText=${actualText} expectedText=${expectedText}`);
        }
        return actualText === expectedText;
    }), { timeout: CLI.waitTimeout });
}
describe(`remove command output verify editor content is preserved ${process.env.MOCHA_RUN_TARGET ||
    ''}`, function () {
    before(Common.before(this));
    after(Common.after(this));
    let res1;
    it('should echo hi', () => __awaiter(this, void 0, void 0, function* () {
        try {
            res1 = yield CLI.command('echo hi', this.app);
            yield ReplExpect.okWithPtyOutput('hi')(res1);
        }
        catch (err) {
            yield Common.oops(this, true)(err);
        }
    }));
    let res2;
    const filepath = join(tmpdir(), v4());
    const typeThis = 'xxxxxxxxx';
    it('should open editor and type something', () => __awaiter(this, void 0, void 0, function* () {
        try {
            res2 = yield CLI.command(`edit "${filepath}"}`, this.app).then(SidecarExpect.open);
            yield setValue(res2, typeThis);
            yield expectText(res2, typeThis);
        }
        catch (err) {
            yield Common.oops(this, true)(err);
        }
    }));
    it('should remove the first block', () => Util.removeBlock(res1).catch(Common.oops(this, true)));
    // verify that we are back to the same number of blocks that we had after the first command (res1)
    ReplExpect.blockCount
        .bind(this)()
        .inSplit(1)
        .is(() => res1.count + 2); // N+1, but also +1 for the current active block, hence +2
    it('should still show the typed text in the editor', () => expectText(res1, typeThis).catch(Common.oops(this, true)));
});
//# sourceMappingURL=edit-remove-block.js.map