"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.SymbolTable = void 0;

var _tab = require("../webapp/tab");

var _sessionStore = _interopRequireDefault(require("../models/sessionStore"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/*
 * Copyright 2019 The Kubernetes Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * the key in localStorage to get the symbol table
 *
 */
class SymbolTable {
  constructor() {
    this.symbolTableSessionStorageKey = 'kui.symbol_table';
  }

  getSymbolTable() {
    return JSON.parse((0, _sessionStore.default)().getItem(this.symbolTableSessionStorageKey)) || {};
  }

  read(tab) {
    return this.getSymbolTable()[(0, _tab.getTabId)(tab)] || {};
  }

  write(tab, curDic) {
    const storage = this.getSymbolTable();
    storage[(0, _tab.getTabId)(tab)] = curDic;
    (0, _sessionStore.default)().setItem(this.symbolTableSessionStorageKey, JSON.stringify(storage));
  }

}

exports.SymbolTable = SymbolTable;

var _default = new SymbolTable();

exports.default = _default;