import { EvaluatorArgs as Arguments, ParsedOptions } from '../command';
import { ReactElement } from 'react';
import { Tab } from '../../webapp/tab';
import { Table } from '../../webapp/models/table';
import { Entity, MetadataBearing } from '../entity';
import { ModeOrButton, Button } from './types';
import { ToolbarText } from '../../webapp/views/toolbar-text';
import { Editable } from '../editable';
/**
 * A `ScalarResource` is Any kind of resource that is directly
 * represented, as opposed to being implicitly represented by a
 * function call.
 *
 */
export declare type ScalarResource = string | HTMLElement | Table;
export interface ScalarContent<T = ScalarResource> {
    content: T;
}
export declare type ToolbarProps = {
    willUpdateToolbar?: (toolbarText: ToolbarText, extraButtons?: Button[], extraButtonsOverride?: boolean) => void;
};
export declare type ReactProvider = {
    react: (props: ToolbarProps) => ReactElement<any>;
};
export declare function isReactProvider(entity: ScalarLike<MetadataBearing>): entity is ReactProvider;
declare type ScalarLike<T extends MetadataBearing> = Entity | ScalarResource | ScalarContent | Content<T> | MetadataBearing | ModeOrButton<T> | ReactProvider;
export declare function isScalarContent<T extends MetadataBearing>(entity: ScalarLike<T>): entity is ScalarContent;
/**
 * Supported String content types
 *
 */
export declare type SupportedStringContent = 'yaml' | 'text/markdown' | 'text/html' | 'json' | 'shell' | 'text/plain';
export declare function isSupportedContentType(contentType: string): boolean;
/**
 * Trait that provides optional contentType for string content
 *
 */
interface WithOptionalContentType<ContentType = SupportedStringContent> {
    contentType?: ContentType;
}
/**
 * Special case of `ScalarContent` for strings; string content may
 * optionally provide a `contentType`.
 *
 */
export declare type StringContent<ContentType = SupportedStringContent> = ScalarContent<string> & WithOptionalContentType<ContentType> & Partial<Editable>;
export declare function isStringWithOptionalContentType<T extends MetadataBearing>(entity: Entity | Content<T> | MetadataBearing | ModeOrButton<T>): entity is StringContent;
/**
 * Compare 2 `StringContent`
 *
 */
export declare type StringDiffContent<ContentType = SupportedStringContent> = {
    content: {
        a: string;
        b: string;
    };
    contentType: ContentType;
};
export declare function isStringDiffContent<T extends MetadataBearing>(entity: Entity | Content<T> | MetadataBearing | ModeOrButton<T>): entity is StringDiffContent;
/**
 * `Content` as `FunctionThatProducesContent<T>` is a function that
 * takes a `T` and produces either a resource or some { content,
 * contentType } wrapper.
 *
 */
export declare type FunctionThatProducesContent<T extends MetadataBearing = MetadataBearing> = (tab: Tab, entity: T, args: {
    argsForMode?: Arguments;
    argvNoOptions: string[];
    parsedOptions: ParsedOptions;
}) => ReactProvider | ScalarResource | ScalarContent | Promise<ScalarResource | ScalarContent | ReactProvider> | CommandStringContent;
export interface FunctionContent<T extends MetadataBearing> {
    content: FunctionThatProducesContent<T>;
}
export declare function isFunctionContent<T extends MetadataBearing = MetadataBearing>(content: Entity | Content<T> | MetadataBearing | ModeOrButton<T>): content is FunctionContent<T>;
/**
 * `Content` as `CommandStringContent` will be executed via a
 * REPL.qexec; the command is assumed to return either
 * `ScalarRersource` or `ScalarContent`.
 *
 */
export declare type CommandStringContent = WithOptionalContentType<SupportedStringContent> & {
    contentFrom: string;
};
export declare function isCommandStringContent<T extends MetadataBearing>(content: ScalarResource | Content<T> | MetadataBearing | ModeOrButton<T>): content is CommandStringContent;
/**
 * The classes of supported `Content` are:
 * - `ScalarContent`: such as pre-formatted HTML, or or `Table` model
 * - `StringContent`: a string with an optional `contentType`
 * - `FunctionContent<T>`: a function that takes a `T` and produces `ScalarContent`
 * - `CommandStringContent`: a string to be executed as a Kui command, and producing `ScalarContent`
 *
 */
export declare type Content<T extends MetadataBearing = MetadataBearing> = ScalarContent | StringContent | StringDiffContent | FunctionContent<T> | CommandStringContent | ReactProvider;
export declare function hasContent<T extends MetadataBearing>(resource: ScalarResource | Content<T> | ModeOrButton<T>): resource is Content<T>;
export {};
