"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = _default;

var _core = require("@kui-shell/core");

var _get = require("../get");

var _tableToMap = require("../../../lib/view/modes/table-to-map");

var _options = require("../options");

/*
 * Copyright 2020 The Kubernetes Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __awaiter = void 0 && (void 0).__awaiter || function (thisArg, _arguments, P, generator) {
  function adopt(value) {
    return value instanceof P ? value : new P(function (resolve) {
      resolve(value);
    });
  }

  return new (P || (P = Promise))(function (resolve, reject) {
    function fulfilled(value) {
      try {
        step(generator.next(value));
      } catch (e) {
        reject(e);
      }
    }

    function rejected(value) {
      try {
        step(generator["throw"](value));
      } catch (e) {
        reject(e);
      }
    }

    function step(result) {
      result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected);
    }

    step((generator = generator.apply(thisArg, _arguments || [])).next());
  });
};

const defaultLimit = 200;
/**
 * Expound on the variant ways to express the given kind. For example,
 * singular versus plural, with or without the api group, etc.
 *
 */

function variantsOf(kind, version, group) {
  return (0, _core.flatten)((0, _core.flatten)([kind, `${kind}s`].map(kind => [kind, (0, _tableToMap.capitalize)(kind)])).map(kind => [kind, `${kind}.${group}`, `${kind}.${version}.${group}`]));
}

function _default(registrar) {
  ;
  ['kubectl', 'k'].forEach(kubectl => {
    const standardGet = (0, _get.doGet)(kubectl);
    variantsOf('job', 'v1', 'batch').forEach(job => {
      registrar.listen(`/${kubectl}/get/${job}`, args => __awaiter(this, void 0, void 0, function* () {
        if ((0, _options.formatOf)(args)) {
          // user asked for a specific output format, use the standard get handler
          return standardGet(args);
        }

        const listOfJobs = args.argvNoOptions.slice(args.argvNoOptions.indexOf(job) + 1);
        const labelSelector = listOfJobs.length === 0 ? 'job-name' : `'job-name in (${listOfJobs.join(',')})'`; // 1) inherit kubeconfig from given args
        // 2) inherit watch request from given args
        // 3) sort by startTime
        // 4) use custom columns: JOB, PODNAME, STATUS, pod start time, container start time, pod end time

        const cmdline = (0, _options.withKubeconfigFrom)(args, `kubectl get pod -l ${labelSelector} --sort-by={.status.startTime} -o custom-columns=JOB:.metadata.ownerReferences[0].name,NAME:.metadata.name,STATUS:.status.phase,START:.status.startTime,START2:.status.containerStatuses[0].state.terminated.startedAt,END:.status.containerStatuses[0].state.terminated.finishedAt ${(0, _options.watchRequestFrom)(args)} ${args.parsedOptions.limit ? `--limit ${args.parsedOptions.limit}` : `--limit ${defaultLimit}`}`);
        const table = yield args.REPL.qexec(cmdline, undefined, undefined, args.execOptions);

        if ((0, _core.isTable)(table)) {
          // improve tables for Jobs
          table.title = 'Job';
          return table;
        } else {
          return table;
        }
      }), _get.getFlags);
    });
  });
}