"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = HTTPClient;

var _axios = _interopRequireDefault(require("axios"));

var _needle = _interopRequireDefault(require("needle"));

var _config = require("../lib/shared/config");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

var __awaiter = void 0 && (void 0).__awaiter || function (thisArg, _arguments, P, generator) {
  function adopt(value) {
    return value instanceof P ? value : new P(function (resolve) {
      resolve(value);
    });
  }

  return new (P || (P = Promise))(function (resolve, reject) {
    function fulfilled(value) {
      try {
        step(generator.next(value));
      } catch (e) {
        reject(e);
      }
    }

    function rejected(value) {
      try {
        step(generator["throw"](value));
      } catch (e) {
        reject(e);
      }
    }

    function step(result) {
      result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected);
    }

    step((generator = generator.apply(thisArg, _arguments || [])).next());
  });
};

function getHeaders(config) {
  if (process.env.NODE_ENV === 'development') {
    return {
      'content-type': 'application/json',
      authorization: config.authorization,
      Cookie: config.cookie
    };
  }

  return {
    'content-type': 'application/json',
    'csrf-token': config.xsrfToken
  };
}

function HTTPClient(method, urlType, requestBody) {
  return __awaiter(this, void 0, void 0, function* () {
    const config = yield (0, _config.getConfig)();
    const url = urlType === 'search' ? config.SEARCH_API : config.CONSOLE_API;
    let agent = null;

    if (config.env === 'development') {
      const {
        Agent
      } = yield Promise.resolve().then(() => _interopRequireWildcard(require('https')));
      agent = new Agent({
        rejectUnauthorized: false
      });
    }

    if (process.env.NODE_ENV === 'development') {
      return (0, _needle.default)(method, url, requestBody || {}, {
        json: true,
        headers: getHeaders(config),
        agent,
        timeout: 5000
      }).then(res => {
        return res.body;
      }).catch(err => {
        throw new Error(err);
      });
    }

    return (0, _axios.default)({
      method,
      url,
      headers: getHeaders(config),
      data: requestBody,
      withCredentials: true,
      httpsAgent: agent,
      timeout: 10000
    }).then(res => {
      return res.data;
    }).catch(err => {
      throw new Error(err);
    });
  });
}