import _defineProperty from "@babel/runtime/helpers/defineProperty";
import _toConsumableArray from "@babel/runtime/helpers/toConsumableArray";
import _slicedToArray from "@babel/runtime/helpers/slicedToArray";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["children", "as", "className", "disabled", "small", "size", "kind", "href", "isExpressive", "isSelected", "tabIndex", "type", "renderIcon", "dangerDescription", "iconDescription", "hasIconOnly", "tooltipPosition", "tooltipAlignment", "onClick", "onBlur", "onFocus", "onMouseEnter", "onMouseLeave"];

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import PropTypes from 'prop-types';
import React, { useState, useEffect, useRef } from 'react';
import classNames from 'classnames';
import { ButtonKinds } from '../../prop-types/types';
import deprecate from '../../prop-types/deprecate';
import { composeEventHandlers } from '../../tools/events';
import { keys, matches } from '../../internal/keyboard';
import { usePrefix } from '../../internal/usePrefix';
import { useId } from '../../internal/useId';
import toggleClass from '../../tools/toggleClass';
import { useFeatureFlag } from '../FeatureFlags';
var Button = /*#__PURE__*/React.forwardRef(function Button(_ref, ref) {
  var _classNames;

  var children = _ref.children,
      as = _ref.as,
      className = _ref.className,
      disabled = _ref.disabled,
      small = _ref.small,
      size = _ref.size,
      kind = _ref.kind,
      href = _ref.href,
      isExpressive = _ref.isExpressive,
      isSelected = _ref.isSelected,
      tabIndex = _ref.tabIndex,
      type = _ref.type,
      ButtonImageElement = _ref.renderIcon,
      dangerDescription = _ref.dangerDescription,
      iconDescription = _ref.iconDescription,
      hasIconOnly = _ref.hasIconOnly,
      tooltipPosition = _ref.tooltipPosition,
      tooltipAlignment = _ref.tooltipAlignment,
      onClick = _ref.onClick,
      onBlur = _ref.onBlur,
      onFocus = _ref.onFocus,
      onMouseEnter = _ref.onMouseEnter,
      onMouseLeave = _ref.onMouseLeave,
      other = _objectWithoutProperties(_ref, _excluded);

  var _useState = useState(false),
      _useState2 = _slicedToArray(_useState, 2),
      allowTooltipVisibility = _useState2[0],
      setAllowTooltipVisibility = _useState2[1];

  var _useState3 = useState(false),
      _useState4 = _slicedToArray(_useState3, 2),
      isHovered = _useState4[0],
      setIsHovered = _useState4[1];

  var _useState5 = useState(false),
      _useState6 = _slicedToArray(_useState5, 2),
      isFocused = _useState6[0],
      setIsFocused = _useState6[1];

  var tooltipRef = useRef(null);
  var tooltipTimeout = useRef(null);
  var prefix = usePrefix();

  var closeTooltips = function closeTooltips(evt) {
    var _document;

    var tooltipNode = (_document = document) === null || _document === void 0 ? void 0 : _document.querySelectorAll(".".concat(prefix, "--tooltip--a11y"));

    _toConsumableArray(tooltipNode).map(function (node) {
      toggleClass(node, "".concat(prefix, "--tooltip--hidden"), node !== evt.currentTarget);
    });
  };

  var handleFocus = function handleFocus(evt) {
    if (hasIconOnly) {
      closeTooltips(evt);
      setIsFocused(true);
      setAllowTooltipVisibility(true);
    }
  };

  var handleBlur = function handleBlur() {
    if (hasIconOnly) {
      setIsHovered(false);
      setIsFocused(false);
      setAllowTooltipVisibility(false);
    }
  };

  var handleMouseEnter = function handleMouseEnter(evt) {
    if (hasIconOnly) {
      tooltipTimeout.current && clearTimeout(tooltipTimeout.current);

      if (evt.target === tooltipRef.current) {
        setAllowTooltipVisibility(true);
        return;
      }

      closeTooltips(evt);
      setAllowTooltipVisibility(true);
    }
  };

  var handleMouseLeave = function handleMouseLeave() {
    if (!isFocused && hasIconOnly) {
      tooltipTimeout.current = setTimeout(function () {
        setAllowTooltipVisibility(false);
        setIsHovered(false);
      }, 100);
    }
  };

  var handleClick = function handleClick(evt) {
    // Prevent clicks on the tooltip from triggering the button click event
    setAllowTooltipVisibility(false);

    if (evt.target === tooltipRef.current) {
      evt.preventDefault();
      return;
    }
  };

  useEffect(function () {
    var handleEscKeyDown = function handleEscKeyDown(event) {
      if (matches(event, [keys.Escape])) {
        setAllowTooltipVisibility(false);
        setIsHovered(false);
      }
    };

    document.addEventListener('keydown', handleEscKeyDown);
    return function () {
      return document.removeEventListener('keydown', handleEscKeyDown);
    };
  }, []);
  var enabled = useFeatureFlag('enable-v11-release');
  var buttonClasses = classNames(className, (_classNames = {}, _defineProperty(_classNames, "".concat(prefix, "--btn"), true), _defineProperty(_classNames, "".concat(prefix, "--btn--sm"), size === 'small' && !isExpressive || size === 'sm' && !isExpressive || small && !isExpressive), _defineProperty(_classNames, "".concat(prefix, "--btn--md"), size === 'field' && !isExpressive || size === 'md' && !isExpressive), _defineProperty(_classNames, "".concat(prefix, "--btn--lg"), enabled ? size === 'xl' : size === 'lg'), _defineProperty(_classNames, "".concat(prefix, "--btn--xl"), enabled ? size === '2xl' : size === 'xl'), _defineProperty(_classNames, "".concat(prefix, "--btn--").concat(kind), kind), _defineProperty(_classNames, "".concat(prefix, "--btn--disabled"), disabled), _defineProperty(_classNames, "".concat(prefix, "--btn--expressive"), isExpressive), _defineProperty(_classNames, "".concat(prefix, "--tooltip--visible"), !enabled && isHovered), _defineProperty(_classNames, "".concat(prefix, "--tooltip--hidden"), !enabled && hasIconOnly && !allowTooltipVisibility), _defineProperty(_classNames, "".concat(prefix, "--btn--icon-only"), hasIconOnly), _defineProperty(_classNames, "".concat(prefix, "--btn--selected"), hasIconOnly && isSelected && kind === 'ghost'), _defineProperty(_classNames, "".concat(prefix, "--tooltip__trigger"), !enabled && hasIconOnly), _defineProperty(_classNames, "".concat(prefix, "--tooltip--a11y"), !enabled && hasIconOnly), _defineProperty(_classNames, "".concat(prefix, "--btn--icon-only--").concat(tooltipPosition), !enabled && hasIconOnly && tooltipPosition), _defineProperty(_classNames, "".concat(prefix, "--tooltip--align-").concat(tooltipAlignment), !enabled && hasIconOnly && tooltipAlignment), _classNames));
  var commonProps = {
    tabIndex: tabIndex,
    className: buttonClasses,
    ref: ref
  };
  var buttonImage = !ButtonImageElement ? null : /*#__PURE__*/React.createElement(ButtonImageElement, {
    "aria-label": iconDescription,
    className: "".concat(prefix, "--btn__icon"),
    "aria-hidden": "true"
  });
  var dangerButtonVariants = ['danger', 'danger--tertiary', 'danger--ghost'];
  var component = 'button';
  var assistiveId = useId('danger-description');
  var otherProps = {
    disabled: disabled,
    type: type,
    'aria-describedby': dangerButtonVariants.includes(kind) ? assistiveId : null,
    'aria-pressed': hasIconOnly && kind === 'ghost' ? isSelected : null
  };
  var anchorProps = {
    href: href
  };
  var assistiveText;

  if (hasIconOnly) {
    assistiveText = /*#__PURE__*/React.createElement("div", {
      ref: tooltipRef,
      onMouseEnter: handleMouseEnter,
      className: "".concat(prefix, "--assistive-text")
    }, iconDescription);
  } else if (dangerButtonVariants.includes(kind)) {
    assistiveText = /*#__PURE__*/React.createElement("span", {
      id: assistiveId,
      className: "".concat(prefix, "--visually-hidden")
    }, dangerDescription);
  } else {
    assistiveText = null;
  }

  if (as) {
    component = as;
    otherProps = _objectSpread(_objectSpread({}, otherProps), anchorProps);
  } else if (href && !disabled) {
    component = 'a';
    otherProps = anchorProps;
  }

  if (enabled) {
    delete otherProps['aria-describedby'];
    return /*#__PURE__*/React.createElement(component, _objectSpread(_objectSpread(_objectSpread({
      onMouseEnter: onMouseEnter,
      onMouseLeave: onMouseLeave,
      onFocus: onFocus,
      onBlur: onBlur,
      onClick: onClick,
      type: type
    }, other), commonProps), otherProps), children);
  }

  return /*#__PURE__*/React.createElement(component, _objectSpread(_objectSpread(_objectSpread({
    onMouseEnter: composeEventHandlers([onMouseEnter, handleMouseEnter]),
    onMouseLeave: composeEventHandlers([onMouseLeave, handleMouseLeave]),
    onFocus: composeEventHandlers([onFocus, handleFocus]),
    onBlur: composeEventHandlers([onBlur, handleBlur]),
    onClick: composeEventHandlers([onClick, handleClick])
  }, other), commonProps), otherProps), assistiveText, children, buttonImage);
});
Button.displayName = 'Button';
Button.propTypes = {
  /**
   * Specify how the button itself should be rendered.
   * Make sure to apply all props to the root node and render children appropriately
   */
  as: PropTypes.oneOfType([PropTypes.func, PropTypes.string, PropTypes.elementType]),

  /**
   * Specify the content of your Button
   */
  children: PropTypes.node,

  /**
   * Specify an optional className to be added to your Button
   */
  className: PropTypes.string,

  /**
   * Specify the message read by screen readers for the danger button variant
   */
  dangerDescription: PropTypes.string,

  /**
   * Specify whether the Button should be disabled, or not
   */
  disabled: PropTypes.bool,

  /**
   * Specify if the button is an icon-only button
   */
  hasIconOnly: PropTypes.bool,

  /**
   * Optionally specify an href for your Button to become an `<a>` element
   */
  href: PropTypes.string,

  /**
   * If specifying the `renderIcon` prop, provide a description for that icon that can
   * be read by screen readers
   */
  iconDescription: function iconDescription(props) {
    if (props.renderIcon && !props.children && !props.iconDescription) {
      return new Error('renderIcon property specified without also providing an iconDescription property.');
    }

    return undefined;
  },

  /**
   * Specify whether the Button is expressive, or not
   */
  isExpressive: PropTypes.bool,

  /**
   * Specify whether the Button is currently selected
   */
  isSelected: PropTypes.bool,

  /**
   * Specify the kind of Button you want to create
   */
  kind: PropTypes.oneOf(ButtonKinds).isRequired,

  /**
   * Provide an optional function to be called when the button element
   * loses focus
   */
  onBlur: PropTypes.func,

  /**
   * Provide an optional function to be called when the button element
   * is clicked
   */
  onClick: PropTypes.func,

  /**
   * Provide an optional function to be called when the button element
   * receives focus
   */
  onFocus: PropTypes.func,

  /**
   * Provide an optional function to be called when the mouse
   * enters the button element
   */
  onMouseEnter: PropTypes.func,

  /**
   * Provide an optional function to be called when the mouse
   * leaves the button element
   */
  onMouseLeave: PropTypes.func,

  /**
   * Optional prop to allow overriding the icon rendering.
   * Can be a React component class
   */
  renderIcon: PropTypes.oneOfType([PropTypes.func, PropTypes.object]),

  /**
   * Optional prop to specify the role of the Button
   */
  role: PropTypes.string,

  /**
   * Specify the size of the button, from a list of available sizes.
   * For `default` buttons, this prop can remain unspecified or use `default`.
   * In the next major release of Carbon, `default`, `field`, and `small` will be removed
   */
  size: PropTypes.oneOf(['default', 'field', 'small', 'sm', 'md', 'lg', 'xl', '2xl']),

  /**
   * Deprecated in v10 in favor of `size`.
   * Specify whether the Button should be a small variant
   */
  small: deprecate(PropTypes.bool, "\nThe prop `small` for Button has been deprecated in favor of `size`. Please use `size=\"sm\"` instead."),

  /**
   * Optional prop to specify the tabIndex of the Button
   */
  tabIndex: PropTypes.number,

  /**
   * Specify the alignment of the tooltip to the icon-only button.
   * Can be one of: start, center, or end.
   */
  tooltipAlignment: PropTypes.oneOf(['start', 'center', 'end']),

  /**
   * Specify the direction of the tooltip for icon-only buttons.
   * Can be either top, right, bottom, or left.
   */
  tooltipPosition: PropTypes.oneOf(['top', 'right', 'bottom', 'left']),

  /**
   * Optional prop to specify the type of the Button
   */
  type: PropTypes.oneOf(['button', 'reset', 'submit'])
};
Button.defaultProps = {
  tabIndex: 0,
  type: 'button',
  disabled: false,
  kind: 'primary',
  size: 'default',
  dangerDescription: 'danger',
  tooltipAlignment: 'center',
  tooltipPosition: 'top',
  isExpressive: false
};
export default Button;