import _extends from "@babel/runtime/helpers/extends";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["className"];

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import PropTypes from 'prop-types';
import React from 'react';
import cx from 'classnames';
import { usePrefix } from '../../internal/usePrefix';

var CheckboxSkeleton = function CheckboxSkeleton(_ref) {
  var className = _ref.className,
      rest = _objectWithoutProperties(_ref, _excluded);

  var prefix = usePrefix();
  return /*#__PURE__*/React.createElement("div", _extends({
    className: cx("".concat(prefix, "--form-item"), "".concat(prefix, "--checkbox-wrapper"), "".concat(prefix, "--checkbox-label"), className)
  }, rest), /*#__PURE__*/React.createElement("span", {
    className: "".concat(prefix, "--checkbox-label-text ").concat(prefix, "--skeleton")
  }));
};

CheckboxSkeleton.propTypes = {
  /**
   * Specify an optional className to add.
   */
  className: PropTypes.string
};
export default CheckboxSkeleton;