import _extends from "@babel/runtime/helpers/extends";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["className", "id", "labelText", "onChange", "indeterminate", "hideLabel", "wrapperClassName", "title"];

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import PropTypes from 'prop-types';
import React from 'react';
import classNames from 'classnames';
import { Text } from '../Text';
import { useFeatureFlag } from '../FeatureFlags';
import deprecate from '../../prop-types/deprecate';
import { usePrefix } from '../../internal/usePrefix';
var Checkbox = /*#__PURE__*/React.forwardRef(function Checkbox(_ref, _ref2) {
  var className = _ref.className,
      id = _ref.id,
      labelText = _ref.labelText,
      _onChange = _ref.onChange,
      indeterminate = _ref.indeterminate,
      hideLabel = _ref.hideLabel,
      wrapperClassName = _ref.wrapperClassName,
      _ref$title = _ref.title,
      title = _ref$title === void 0 ? '' : _ref$title,
      other = _objectWithoutProperties(_ref, _excluded);

  var enabled = useFeatureFlag('enable-v11-release');
  var prefix = usePrefix();
  var labelClasses = classNames("".concat(prefix, "--checkbox-label"), [enabled ? null : className]);
  var innerLabelClasses = classNames("".concat(prefix, "--checkbox-label-text"), _defineProperty({}, "".concat(prefix, "--visually-hidden"), hideLabel));
  var wrapperClasses = classNames("".concat(prefix, "--form-item"), "".concat(prefix, "--checkbox-wrapper"), [enabled ? className : wrapperClassName]);
  return /*#__PURE__*/React.createElement("div", {
    className: wrapperClasses
  }, /*#__PURE__*/React.createElement("input", _extends({}, other, {
    type: "checkbox",
    onChange: function onChange(evt) {
      if (enabled) {
        _onChange(evt, {
          checked: evt.target.checked,
          id: id
        });
      } else {
        _onChange(evt.target.checked, id, evt);
      }
    },
    className: "".concat(prefix, "--checkbox"),
    id: id,
    ref: function ref(el) {
      if (el) {
        el.indeterminate = indeterminate;
      }

      if (typeof _ref2 === 'function') {
        _ref2(el);
      } else if (Object(_ref2) === _ref2) {
        _ref2.current = el;
      }
    }
  })), /*#__PURE__*/React.createElement("label", {
    htmlFor: id,
    className: labelClasses,
    title: title || null
  }, /*#__PURE__*/React.createElement(Text, {
    className: innerLabelClasses
  }, labelText)));
});
Checkbox.propTypes = {
  /**
   * Specify whether the underlying input should be checked
   */
  checked: PropTypes.bool,

  /**
   * Specify an optional className to be applied to the <label> node
   */
  className: PropTypes.string,

  /**
   * Specify whether the underlying input should be checked by default
   */
  defaultChecked: PropTypes.bool,

  /**
   * Specify whether the Checkbox should be disabled
   */
  disabled: PropTypes.bool,

  /**
   * Specify whether the label should be hidden, or not
   */
  hideLabel: PropTypes.bool,

  /**
   * Provide an `id` to uniquely identify the Checkbox input
   */
  id: PropTypes.string.isRequired,

  /**
   * Specify whether the Checkbox is in an indeterminate state
   */
  indeterminate: PropTypes.bool,

  /**
   * Provide a label to provide a description of the Checkbox input that you are
   * exposing to the user
   */
  labelText: PropTypes.node.isRequired,

  /**
   * Receives three arguments: true/false, the checkbox's id, and the dom event.
   * `(value, id, event) => console.log({value, id, event})`
   */
  onChange: PropTypes.func,

  /**
   * Specify a title for the <label> node for the Checkbox
   */
  title: PropTypes.string,

  /**
   * The CSS class name to be placed on the wrapping element
   */
  wrapperClassName: deprecate(PropTypes.string, "\nThe prop `wrapperClassName` for Checkbox will be deprecated in V11 in favor of `className`. `className` will then be placed on the outer wrapper.")
};
Checkbox.defaultProps = {
  onChange: function onChange() {},
  indeterminate: false
};
Checkbox.displayName = 'Checkbox';
export default Checkbox;