/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import React from 'react';
import { default as CodeSnippet, CodeSnippetSkeleton } from '../';
import { Layer } from '../../Layer';
export default {
  title: 'Components/CodeSnippet',
  component: CodeSnippet
};
export var inline = function inline() {
  return /*#__PURE__*/React.createElement(CodeSnippet, {
    type: "inline",
    feedback: "Copied to clipboard"
  }, 'node -v');
};
export var multiline = function multiline() {
  return /*#__PURE__*/React.createElement(CodeSnippet, {
    type: "multi",
    feedback: "Copied to clipboard"
  }, "  \"scripts\": {\n    \"build\": \"lerna run build --stream --prefix --npm-client yarn\",\n    \"ci-check\": \"carbon-cli ci-check\",\n    \"clean\": \"lerna run clean && lerna clean --yes && rimraf node_modules\",\n    \"doctoc\": \"doctoc --title '## Table of Contents'\",\n    \"format\": \"prettier --write '**/*.{js,md,scss,ts}' '!**/{build,es,lib,storybook,ts,umd}/**'\",\n    \"format:diff\": \"prettier --list-different '**/*.{js,md,scss,ts}' '!**/{build,es,lib,storybook,ts,umd}/**' '!packages/components/**'\",\n    \"lint\": \"eslint actions config codemods packages\",\n    \"lint:styles\": \"stylelint '**/*.{css,scss}' --report-needless-disables --report-invalid-scope-disables\",\n    \"sync\": \"carbon-cli sync\",\n    \"test\": \"cross-env BABEL_ENV=test jest\",\n    \"test:e2e\": \"cross-env BABEL_ENV=test jest --testPathPattern=e2e --testPathIgnorePatterns='examples,/packages/components/,/packages/react/'\"\n  },\n  \"resolutions\": {\n    \"react\": \"~16.9.0\",\n    \"react-dom\": \"~16.9.0\",\n    \"react-is\": \"~16.9.0\",\n    \"react-test-renderer\": \"~16.9.0\"\n  },\n  \"devDependencies\": {\n    \"@babel/core\": \"^7.10.0\",\n    \"@babel/plugin-proposal-class-properties\": \"^7.7.4\",\n    \"@babel/plugin-proposal-export-default-from\": \"^7.7.4\",\n    \"@babel/plugin-proposal-export-namespace-from\": \"^7.7.4\",\n    \"@babel/plugin-transform-runtime\": \"^7.10.0\",\n    \"@babel/preset-env\": \"^7.10.0\",\n    \"@babel/preset-react\": \"^7.10.0\",\n    \"@babel/runtime\": \"^7.10.0\",\n    \"@commitlint/cli\": \"^8.3.5\",");
};
export var singleline = function singleline() {
  return /*#__PURE__*/React.createElement(CodeSnippet, {
    type: "single",
    feedback: "Copied to clipboard"
  }, "yarn add carbon-components@latest carbon-components-react@latest @carbon/icons-react@latest carbon-icons@latest");
};
export var inlineWithLayer = function inlineWithLayer() {
  return /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(CodeSnippet, {
    type: "inline",
    feedback: "Copied to clipboard"
  }, 'node -v'), /*#__PURE__*/React.createElement(Layer, null, /*#__PURE__*/React.createElement(CodeSnippet, {
    type: "inline",
    feedback: "Copied to clipboard"
  }, 'node -v'), /*#__PURE__*/React.createElement(Layer, null, /*#__PURE__*/React.createElement(CodeSnippet, {
    type: "inline",
    feedback: "Copied to clipboard"
  }, 'node -v'))));
};
export var multilineWithLayer = function multilineWithLayer() {
  return /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(CodeSnippet, {
    type: "multi",
    feedback: "Copied to clipboard"
  }, "  \"scripts\": {\n        \"build\": \"lerna run build --stream --prefix --npm-client yarn\",\n        \"ci-check\": \"carbon-cli ci-check\",\n        \"clean\": \"lerna run clean && lerna clean --yes && rimraf node_modules\",\n        \"doctoc\": \"doctoc --title '## Table of Contents'\",\n        \"format\": \"prettier --write '**/*.{js,md,scss,ts}' '!**/{build,es,lib,storybook,ts,umd}/**'\",\n        \"format:diff\": \"prettier --list-different '**/*.{js,md,scss,ts}' '!**/{build,es,lib,storybook,ts,umd}/**' '!packages/components/**'\",\n        \"lint\": \"eslint actions config codemods packages\",\n        \"lint:styles\": \"stylelint '**/*.{css,scss}' --report-needless-disables --report-invalid-scope-disables\",\n        \"sync\": \"carbon-cli sync\",\n        \"test\": \"cross-env BABEL_ENV=test jest\",\n        \"test:e2e\": \"cross-env BABEL_ENV=test jest --testPathPattern=e2e --testPathIgnorePatterns='examples,/packages/components/,/packages/react/'\"\n        },\n        \"resolutions\": {\n          \"react\": \"~16.9.0\",\n          \"react-dom\": \"~16.9.0\",\n          \"react-is\": \"~16.9.0\",\n          \"react-test-renderer\": \"~16.9.0\"\n        },\n        \"devDependencies\": {\n          \"@babel/core\": \"^7.10.0\",\n          \"@babel/plugin-proposal-class-properties\": \"^7.7.4\",\n          \"@babel/plugin-proposal-export-default-from\": \"^7.7.4\",\n          \"@babel/plugin-proposal-export-namespace-from\": \"^7.7.4\",\n          \"@babel/plugin-transform-runtime\": \"^7.10.0\",\n          \"@babel/preset-env\": \"^7.10.0\",\n          \"@babel/preset-react\": \"^7.10.0\",\n          \"@babel/runtime\": \"^7.10.0\",\n          \"@commitlint/cli\": \"^8.3.5\","), /*#__PURE__*/React.createElement(Layer, null, /*#__PURE__*/React.createElement(CodeSnippet, {
    type: "multi",
    feedback: "Copied to clipboard"
  }, "  \"scripts\": {\n          \"build\": \"lerna run build --stream --prefix --npm-client yarn\",\n          \"ci-check\": \"carbon-cli ci-check\",\n          \"clean\": \"lerna run clean && lerna clean --yes && rimraf node_modules\",\n          \"doctoc\": \"doctoc --title '## Table of Contents'\",\n          \"format\": \"prettier --write '**/*.{js,md,scss,ts}' '!**/{build,es,lib,storybook,ts,umd}/**'\",\n          \"format:diff\": \"prettier --list-different '**/*.{js,md,scss,ts}' '!**/{build,es,lib,storybook,ts,umd}/**' '!packages/components/**'\",\n          \"lint\": \"eslint actions config codemods packages\",\n          \"lint:styles\": \"stylelint '**/*.{css,scss}' --report-needless-disables --report-invalid-scope-disables\",\n          \"sync\": \"carbon-cli sync\",\n          \"test\": \"cross-env BABEL_ENV=test jest\",\n          \"test:e2e\": \"cross-env BABEL_ENV=test jest --testPathPattern=e2e --testPathIgnorePatterns='examples,/packages/components/,/packages/react/'\"\n          },\n          \"resolutions\": {\n            \"react\": \"~16.9.0\",\n            \"react-dom\": \"~16.9.0\",\n            \"react-is\": \"~16.9.0\",\n            \"react-test-renderer\": \"~16.9.0\"\n          },\n          \"devDependencies\": {\n            \"@babel/core\": \"^7.10.0\",\n            \"@babel/plugin-proposal-class-properties\": \"^7.7.4\",\n            \"@babel/plugin-proposal-export-default-from\": \"^7.7.4\",\n            \"@babel/plugin-proposal-export-namespace-from\": \"^7.7.4\",\n            \"@babel/plugin-transform-runtime\": \"^7.10.0\",\n            \"@babel/preset-env\": \"^7.10.0\",\n            \"@babel/preset-react\": \"^7.10.0\",\n            \"@babel/runtime\": \"^7.10.0\",\n            \"@commitlint/cli\": \"^8.3.5\","), /*#__PURE__*/React.createElement(Layer, null, /*#__PURE__*/React.createElement(CodeSnippet, {
    type: "multi",
    feedback: "Copied to clipboard"
  }, "  \"scripts\": {\n            \"build\": \"lerna run build --stream --prefix --npm-client yarn\",\n            \"ci-check\": \"carbon-cli ci-check\",\n            \"clean\": \"lerna run clean && lerna clean --yes && rimraf node_modules\",\n            \"doctoc\": \"doctoc --title '## Table of Contents'\",\n            \"format\": \"prettier --write '**/*.{js,md,scss,ts}' '!**/{build,es,lib,storybook,ts,umd}/**'\",\n            \"format:diff\": \"prettier --list-different '**/*.{js,md,scss,ts}' '!**/{build,es,lib,storybook,ts,umd}/**' '!packages/components/**'\",\n            \"lint\": \"eslint actions config codemods packages\",\n            \"lint:styles\": \"stylelint '**/*.{css,scss}' --report-needless-disables --report-invalid-scope-disables\",\n            \"sync\": \"carbon-cli sync\",\n            \"test\": \"cross-env BABEL_ENV=test jest\",\n            \"test:e2e\": \"cross-env BABEL_ENV=test jest --testPathPattern=e2e --testPathIgnorePatterns='examples,/packages/components/,/packages/react/'\"\n            },\n            \"resolutions\": {\n              \"react\": \"~16.9.0\",\n              \"react-dom\": \"~16.9.0\",\n              \"react-is\": \"~16.9.0\",\n              \"react-test-renderer\": \"~16.9.0\"\n            },\n            \"devDependencies\": {\n              \"@babel/core\": \"^7.10.0\",\n              \"@babel/plugin-proposal-class-properties\": \"^7.7.4\",\n              \"@babel/plugin-proposal-export-default-from\": \"^7.7.4\",\n              \"@babel/plugin-proposal-export-namespace-from\": \"^7.7.4\",\n              \"@babel/plugin-transform-runtime\": \"^7.10.0\",\n              \"@babel/preset-env\": \"^7.10.0\",\n              \"@babel/preset-react\": \"^7.10.0\",\n              \"@babel/runtime\": \"^7.10.0\",\n              \"@commitlint/cli\": \"^8.3.5\","))));
};
export var singlelineWithLayer = function singlelineWithLayer() {
  return /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(CodeSnippet, {
    type: "single",
    feedback: "Copied to clipboard"
  }, "yarn add carbon-components@latest carbon-components-react@latest @carbon/icons-react@latest carbon-icons@latest"), /*#__PURE__*/React.createElement(Layer, null, /*#__PURE__*/React.createElement(CodeSnippet, {
    type: "single",
    feedback: "Copied to clipboard"
  }, "yarn add carbon-components@latest carbon-components-react@latest @carbon/icons-react@latest carbon-icons@latest"), /*#__PURE__*/React.createElement(Layer, null, /*#__PURE__*/React.createElement(CodeSnippet, {
    type: "single",
    feedback: "Copied to clipboard"
  }, "yarn add carbon-components@latest carbon-components-react@latest @carbon/icons-react@latest carbon-icons@latest"))));
};
export var skeleton = function skeleton() {
  return /*#__PURE__*/React.createElement("div", null, /*#__PURE__*/React.createElement(CodeSnippetSkeleton, {
    type: "single",
    style: {
      marginBottom: 8
    }
  }), /*#__PURE__*/React.createElement(CodeSnippetSkeleton, {
    type: "multi"
  }));
};