import _extends from "@babel/runtime/helpers/extends";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["className", "children", "useZebraStyles", "size", "isSortable", "useStaticWidth", "shouldShowBorder", "stickyHeader", "overflowMenuOnHover"];

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import React from 'react';
import PropTypes from 'prop-types';
import cx from 'classnames';
import { settings } from 'carbon-components';
import deprecate from '../../prop-types/deprecate.js';
var prefix = settings.prefix;
export var Table = function Table(_ref) {
  var _cx;

  var className = _ref.className,
      children = _ref.children,
      useZebraStyles = _ref.useZebraStyles,
      size = _ref.size,
      isSortable = _ref.isSortable,
      useStaticWidth = _ref.useStaticWidth,
      shouldShowBorder = _ref.shouldShowBorder,
      stickyHeader = _ref.stickyHeader,
      overflowMenuOnHover = _ref.overflowMenuOnHover,
      other = _objectWithoutProperties(_ref, _excluded);

  var componentClass = cx("".concat(prefix, "--data-table"), className, (_cx = {}, _defineProperty(_cx, "".concat(prefix, "--data-table--").concat(size), size), _defineProperty(_cx, "".concat(prefix, "--data-table--sort"), isSortable), _defineProperty(_cx, "".concat(prefix, "--data-table--zebra"), useZebraStyles), _defineProperty(_cx, "".concat(prefix, "--data-table--static"), useStaticWidth), _defineProperty(_cx, "".concat(prefix, "--data-table--no-border"), !shouldShowBorder), _defineProperty(_cx, "".concat(prefix, "--data-table--sticky-header"), stickyHeader), _defineProperty(_cx, "".concat(prefix, "--data-table--visible-overflow-menu"), !overflowMenuOnHover), _cx));
  var table = /*#__PURE__*/React.createElement("div", {
    className: "".concat(prefix, "--data-table-content")
  }, /*#__PURE__*/React.createElement("table", _extends({}, other, {
    className: componentClass
  }), children));
  return stickyHeader ? /*#__PURE__*/React.createElement("section", {
    className: "".concat(prefix, "--data-table_inner-container")
  }, table) : table;
};
Table.propTypes = {
  /**
   * Pass in the children that will be rendered within the Table
   */
  children: PropTypes.node,
  className: PropTypes.string,

  /**
   * `false` If true, will apply sorting styles
   */
  isSortable: PropTypes.bool,

  /**
   * Specify whether the overflow menu (if it exists) should be shown always, or only on hover
   */
  overflowMenuOnHover: PropTypes.bool,

  /**
   * `false` If true, will remove the table border
   */
  shouldShowBorder: deprecate(PropTypes.bool, 'The `shouldShowBorder` prop has been deprecated and can be safely removed.' + 'This prop will be removed in the next major release of ' + '`carbon-components-react`'),

  /**
   *  Change the row height of table. Currently supports `xs`, `sm`, `md`, `lg`, and `xl`.
   *  The previous terms (`compact`, `short`, `normal`, and `tall`) will be removed in the next major release.
   */
  size: PropTypes.oneOf(['compact', 'short', 'normal', 'tall', 'xs', 'sm', 'md', 'lg', 'xl']),

  /**
   * `false` If true, will keep the header sticky (only data rows will scroll)
   */
  stickyHeader: PropTypes.bool,

  /**
   * `false` If true, will use a width of 'auto' instead of 100%
   */
  useStaticWidth: PropTypes.bool,

  /**
   * `true` to add useZebraStyles striping.
   */
  useZebraStyles: PropTypes.bool
};
Table.defaultProps = {
  isSortable: false,
  overflowMenuOnHover: true
};
export default Table;