import _defineProperty from "@babel/runtime/helpers/defineProperty";
import _typeof from "@babel/runtime/helpers/typeof";
import _slicedToArray from "@babel/runtime/helpers/slicedToArray";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["children", "className", "id", "level", "open", "size", "target", "x", "y", "onClose"];

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

/**
 * Copyright IBM Corp. 2020
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import React, { useEffect, useRef, useState } from 'react';
import ReactDOM from 'react-dom';
import classnames from 'classnames';
import PropTypes from 'prop-types';
import { settings } from 'carbon-components';
import { keys, match } from '../../internal/keyboard';
import { capWithinRange, clickedElementHasSubnodes, focusNode as focusNodeUtil, getNextNode, getParentMenu, getParentNode, getPosition, getValidNodes, resetFocus } from './_utils';
import MenuGroup from './MenuGroup';
import MenuRadioGroup from './MenuRadioGroup';
import MenuRadioGroupOptions from './MenuRadioGroupOptions';
import MenuSelectableItem from './MenuSelectableItem';
var prefix = settings.prefix;
var margin = 16; // distance to keep to body edges, in px

var defaultSize = 'sm';

var Menu = function Menu(_ref) {
  var _classnames;

  var children = _ref.children,
      className = _ref.className,
      id = _ref.id,
      _ref$level = _ref.level,
      level = _ref$level === void 0 ? 1 : _ref$level,
      open = _ref.open,
      _ref$size = _ref.size,
      size = _ref$size === void 0 ? defaultSize : _ref$size,
      _ref$target = _ref.target,
      target = _ref$target === void 0 ? document.body : _ref$target,
      _ref$x = _ref.x,
      x = _ref$x === void 0 ? 0 : _ref$x,
      _ref$y = _ref.y,
      y = _ref$y === void 0 ? 0 : _ref$y,
      _ref$onClose = _ref.onClose,
      onClose = _ref$onClose === void 0 ? function () {} : _ref$onClose,
      rest = _objectWithoutProperties(_ref, _excluded);

  var rootRef = useRef(null);

  var _useState = useState(1),
      _useState2 = _slicedToArray(_useState, 2),
      direction = _useState2[0],
      setDirection = _useState2[1]; // 1 = to right, -1 = to left


  var _useState3 = useState([x, y]),
      _useState4 = _slicedToArray(_useState3, 2),
      position = _useState4[0],
      setPosition = _useState4[1];

  var isRootMenu = level === 1;
  var focusReturn = useRef(null);

  function returnFocus() {
    if (focusReturn.current) {
      focusReturn.current.focus();
    }
  }

  function close(eventType) {
    var isKeyboardEvent = /^key/.test(eventType);

    if (isKeyboardEvent) {
      window.addEventListener('keyup', returnFocus, {
        once: true
      });
    } else {
      window.addEventListener('mouseup', returnFocus, {
        once: true
      });
    }

    onClose();
  }

  function getContainerBoundaries() {
    var _document$body = document.body,
        bodyWidth = _document$body.clientWidth,
        bodyHeight = _document$body.clientHeight;
    return [margin, margin, bodyWidth - margin, bodyHeight - margin];
  }

  function getTargetBoundaries() {
    var xIsRange = _typeof(x) === 'object' && x.length === 2;
    var yIsRange = _typeof(y) === 'object' && y.length === 2;
    var targetBoundaries = [xIsRange ? x[0] : x, yIsRange ? y[0] : y, xIsRange ? x[1] : x, yIsRange ? y[1] : y];

    if (!isRootMenu) {
      var _getParentMenu;

      var _getParentMenu$getBou = (_getParentMenu = getParentMenu(rootRef.current)) === null || _getParentMenu === void 0 ? void 0 : _getParentMenu.getBoundingClientRect(),
          parentWidth = _getParentMenu$getBou.width;

      targetBoundaries[2] -= parentWidth;
    }

    var containerBoundaries = getContainerBoundaries();
    return [capWithinRange(targetBoundaries[0], containerBoundaries[0], containerBoundaries[2]), capWithinRange(targetBoundaries[1], containerBoundaries[1], containerBoundaries[3]), capWithinRange(targetBoundaries[2], containerBoundaries[0], containerBoundaries[2]), capWithinRange(targetBoundaries[3], containerBoundaries[1], containerBoundaries[3])];
  }

  function focusNode(node) {
    if (node) {
      resetFocus(rootRef.current);
      focusNodeUtil(node);
    }
  }

  function handleKeyDown(event) {
    if (match(event, keys.Tab)) {
      event.preventDefault();
      close(event.type);
    }

    if (event.target.tagName === 'LI' && (match(event, keys.Enter) || match(event, keys.Space))) {
      handleClick(event);
    } else {
      event.stopPropagation();
    }

    if (match(event, keys.Escape) || !isRootMenu && match(event, keys.ArrowLeft)) {
      close(event.type);
    }

    var nodeToFocus;

    if (event.target.tagName === 'LI') {
      var currentNode = event.target;

      if (match(event, keys.ArrowUp)) {
        nodeToFocus = getNextNode(currentNode, -1);
      } else if (match(event, keys.ArrowDown)) {
        nodeToFocus = getNextNode(currentNode, 1);
      } else if (match(event, keys.ArrowLeft)) {
        nodeToFocus = getParentNode(currentNode);
      }
    } else if (event.target.tagName === 'UL') {
      var validNodes = getValidNodes(event.target);

      if (validNodes.length > 0 && match(event, keys.ArrowUp)) {
        nodeToFocus = validNodes[validNodes.length - 1];
      } else if (validNodes.length > 0 && match(event, keys.ArrowDown)) {
        nodeToFocus = validNodes[0];
      }
    }

    focusNode(nodeToFocus);

    if (rest.onKeyDown) {
      rest.onKeyDown(event);
    }
  }

  function handleClick(event) {
    if (!clickedElementHasSubnodes(event) && event.target.tagName !== 'UL') {
      close(event.type);
    } else {
      event.stopPropagation();
    }
  }

  function getCorrectedPosition(preferredDirection) {
    var _rootRef$current;

    var elementRect = (_rootRef$current = rootRef.current) === null || _rootRef$current === void 0 ? void 0 : _rootRef$current.getBoundingClientRect();
    var elementDimensions = [elementRect.width, elementRect.height];
    var targetBoundaries = getTargetBoundaries();
    var containerBoundaries = getContainerBoundaries();

    var _getPosition = getPosition(elementDimensions, targetBoundaries, containerBoundaries, preferredDirection),
        correctedPosition = _getPosition.position,
        correctedDirection = _getPosition.direction;

    setDirection(correctedDirection);
    return correctedPosition;
  }

  function handleBlur(event) {
    var _rootRef$current2;

    if (isRootMenu && !((_rootRef$current2 = rootRef.current) !== null && _rootRef$current2 !== void 0 && _rootRef$current2.contains(event.relatedTarget))) {
      close(event.type);
    }
  }

  useEffect(function () {
    if (open) {
      focusReturn.current = document.activeElement;
      var localDirection = 1;

      if (isRootMenu) {
        var _rootRef$current3;

        (_rootRef$current3 = rootRef.current) === null || _rootRef$current3 === void 0 ? void 0 : _rootRef$current3.focus();
      } else {
        var parentMenu = getParentMenu(rootRef.current);

        if (parentMenu) {
          localDirection = Number(parentMenu.dataset.direction);
        }
      }

      var correctedPosition = getCorrectedPosition(localDirection);
      setPosition(correctedPosition);
    } else {
      setPosition([0, 0]);
    } // eslint-disable-next-line react-hooks/exhaustive-deps

  }, [open, x, y]);
  var someNodesHaveIcons = React.Children.toArray(children).some(function (node) {
    return node.type === MenuSelectableItem || node.type === MenuRadioGroup;
  });
  var options = React.Children.map(children, function (node) {
    if ( /*#__PURE__*/React.isValidElement(node)) {
      return /*#__PURE__*/React.cloneElement(node, {
        indented: someNodesHaveIcons,
        level: level
      });
    }
  });
  var classes = classnames("".concat(prefix, "--menu"), (_classnames = {}, _defineProperty(_classnames, "".concat(prefix, "--menu--open"), open), _defineProperty(_classnames, "".concat(prefix, "--menu--invisible"), open && position[0] === 0 && position[1] === 0), _defineProperty(_classnames, "".concat(prefix, "--menu--root"), isRootMenu), _classnames), size !== defaultSize && "".concat(prefix, "--menu--").concat(size), className);

  var ulAttributes = _objectSpread(_objectSpread({}, rest), {}, {
    id: id,
    ref: rootRef,
    className: classes,
    onKeyDown: handleKeyDown,
    onClick: handleClick,
    onBlur: handleBlur,
    role: 'menu',
    tabIndex: -1,
    'data-direction': direction,
    'data-level': level,
    style: {
      left: "".concat(position[0], "px"),
      top: "".concat(position[1], "px")
    }
  });

  var childrenToRender = options; // if the only child is a radiogroup, don't render it as radiogroup component, but
  // only the items to prevent duplicate markup

  if (options && options.length === 1 && options[0].type === MenuRadioGroup) {
    var radioGroupProps = options[0].props;
    ulAttributes['aria-label'] = radioGroupProps.label;
    childrenToRender = /*#__PURE__*/React.createElement(MenuRadioGroupOptions, {
      items: radioGroupProps.items,
      initialSelectedItem: radioGroupProps.initialSelectedItem,
      onChange: radioGroupProps.onChange
    });
  } // if the only child is a generic group, don't render it as group component, but
  // only the children to prevent duplicate markup


  if (options && options.length === 1 && options[0].type === MenuGroup) {
    var groupProps = options[0].props;
    ulAttributes['aria-label'] = groupProps.label;
    childrenToRender = React.Children.toArray(options[0].props.children);
  }

  var menu = /*#__PURE__*/React.createElement("ul", ulAttributes, childrenToRender);
  return isRootMenu ? open && /*#__PURE__*/ReactDOM.createPortal(menu, target) || null : menu;
};

Menu.propTypes = {
  /**
   * Specify the children of the Menu
   */
  children: PropTypes.node,

  /**
   * Specify a custom className to apply to the ul node
   */
  className: PropTypes.string,

  /**
   * Define an ID for this menu
   */
  id: PropTypes.string,

  /**
   * Internal: keeps track of the nesting level of the menu
   */
  level: PropTypes.number,

  /**
   * Function called when the menu is closed
   */
  onClose: PropTypes.func,

  /**
   * Specify whether the Menu is currently open
   */
  open: PropTypes.bool,

  /**
   * Specify the size of the menu, from a list of available sizes.
   */
  size: PropTypes.oneOf(['sm', 'md', 'lg']),

  /**
   * Optionally pass an element the Menu should be appended to as a child. Defaults to document.body.
   */
  target: PropTypes.element,

  /**
   * Specify the x position where this menu is rendered
   */
  x: PropTypes.oneOfType([PropTypes.number, PropTypes.arrayOf(PropTypes.number)]),

  /**
   * Specify the y position where this menu is rendered
   */
  y: PropTypes.oneOfType([PropTypes.number, PropTypes.arrayOf(PropTypes.number)])
};
export default Menu;