import _extends from "@babel/runtime/helpers/extends";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
import _classCallCheck from "@babel/runtime/helpers/classCallCheck";
import _createClass from "@babel/runtime/helpers/createClass";
import _assertThisInitialized from "@babel/runtime/helpers/assertThisInitialized";
import _inherits from "@babel/runtime/helpers/inherits";
import _possibleConstructorReturn from "@babel/runtime/helpers/possibleConstructorReturn";
import _getPrototypeOf from "@babel/runtime/helpers/getPrototypeOf";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
var _excluded = ["children", "onKeyDown", "buttonTriggerText", "buttonTriggerClassName", "renderTriggerButtonIcon", "triggerButtonIconDescription", "triggerButtonKind", "disabled", "handleSubmit", "shouldCloseAfterSubmit", "selectorPrimaryFocus", "preventCloseOnClickOutside"];

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import PropTypes from 'prop-types';
import React from 'react';
import Modal from '../Modal';
import Button from '../Button';
import { ButtonKinds } from '../../prop-types/types';

var ModalWrapper = /*#__PURE__*/function (_React$Component) {
  _inherits(ModalWrapper, _React$Component);

  var _super = _createSuper(ModalWrapper);

  function ModalWrapper() {
    var _this;

    _classCallCheck(this, ModalWrapper);

    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    _this = _super.call.apply(_super, [this].concat(args));

    _defineProperty(_assertThisInitialized(_this), "triggerButton", /*#__PURE__*/React.createRef());

    _defineProperty(_assertThisInitialized(_this), "modal", /*#__PURE__*/React.createRef());

    _defineProperty(_assertThisInitialized(_this), "state", {
      isOpen: false
    });

    _defineProperty(_assertThisInitialized(_this), "handleOpen", function () {
      _this.setState({
        isOpen: true
      });
    });

    _defineProperty(_assertThisInitialized(_this), "handleClose", function (evt) {
      if (evt && !_this.modal.current.innerModal.current.contains(evt.target) && _this.props.preventCloseOnClickOutside) {
        return;
      } else {
        _this.setState({
          isOpen: false
        }, function () {
          return _this.triggerButton.current.focus();
        });
      }
    });

    _defineProperty(_assertThisInitialized(_this), "handleOnRequestSubmit", function () {
      var _this$props = _this.props,
          handleSubmit = _this$props.handleSubmit,
          shouldCloseAfterSubmit = _this$props.shouldCloseAfterSubmit;

      if (handleSubmit()) {
        if (shouldCloseAfterSubmit) {
          _this.handleClose();
        }
      }
    });

    return _this;
  }

  _createClass(ModalWrapper, [{
    key: "render",
    value: function render() {
      var _this2 = this;

      var _this$props2 = this.props,
          children = _this$props2.children,
          _onKeyDown = _this$props2.onKeyDown,
          buttonTriggerText = _this$props2.buttonTriggerText,
          buttonTriggerClassName = _this$props2.buttonTriggerClassName,
          renderTriggerButtonIcon = _this$props2.renderTriggerButtonIcon,
          triggerButtonIconDescription = _this$props2.triggerButtonIconDescription,
          triggerButtonKind = _this$props2.triggerButtonKind,
          disabled = _this$props2.disabled,
          handleSubmit = _this$props2.handleSubmit,
          shouldCloseAfterSubmit = _this$props2.shouldCloseAfterSubmit,
          selectorPrimaryFocus = _this$props2.selectorPrimaryFocus,
          preventCloseOnClickOutside = _this$props2.preventCloseOnClickOutside,
          other = _objectWithoutProperties(_this$props2, _excluded);

      var props = _objectSpread(_objectSpread({}, other), {}, {
        selectorPrimaryFocus: selectorPrimaryFocus,
        open: this.state.isOpen,
        onRequestClose: this.handleClose,
        onRequestSubmit: this.handleOnRequestSubmit
      });

      return /*#__PURE__*/React.createElement("div", {
        role: "presentation",
        onKeyDown: function onKeyDown(evt) {
          if (evt.which === 27) {
            _this2.handleClose();

            _onKeyDown(evt);
          }
        }
      }, /*#__PURE__*/React.createElement(Button, {
        className: buttonTriggerClassName,
        disabled: disabled,
        kind: triggerButtonKind,
        renderIcon: renderTriggerButtonIcon,
        iconDescription: triggerButtonIconDescription,
        onClick: this.handleOpen,
        ref: this.triggerButton
      }, buttonTriggerText), /*#__PURE__*/React.createElement(Modal, _extends({
        ref: this.modal
      }, props), children));
    }
  }]);

  return ModalWrapper;
}(React.Component);

_defineProperty(ModalWrapper, "propTypes", {
  buttonTriggerClassName: PropTypes.string,
  buttonTriggerText: PropTypes.node,
  children: PropTypes.node,
  disabled: PropTypes.bool,
  handleOpen: PropTypes.func,
  handleSubmit: PropTypes.func,
  id: PropTypes.string,
  modalBeforeContent: PropTypes.bool,
  modalHeading: PropTypes.string,
  modalLabel: PropTypes.string,
  modalText: PropTypes.string,
  onKeyDown: PropTypes.func,
  passiveModal: PropTypes.bool,
  preventCloseOnClickOutside: PropTypes.bool,
  primaryButtonText: PropTypes.string,
  renderTriggerButtonIcon: PropTypes.oneOfType([PropTypes.func, PropTypes.object]),
  secondaryButtonText: PropTypes.string,
  selectorPrimaryFocus: PropTypes.string,
  shouldCloseAfterSubmit: PropTypes.bool,
  status: PropTypes.string,
  triggerButtonIconDescription: PropTypes.string,
  triggerButtonKind: PropTypes.oneOf(ButtonKinds),
  withHeader: PropTypes.bool
});

_defineProperty(ModalWrapper, "defaultProps", {
  primaryButtonText: 'Save',
  secondaryButtonText: 'Cancel',
  triggerButtonIconDescription: 'Provide icon description if icon is used',
  triggerButtonKind: 'primary',
  disabled: false,
  preventCloseOnClickOutside: false,
  selectorPrimaryFocus: '[data-modal-primary-focus]',
  onKeyDown: function onKeyDown() {}
});

export { ModalWrapper as default };