import _defineProperty from "@babel/runtime/helpers/defineProperty";
import _slicedToArray from "@babel/runtime/helpers/slicedToArray";
import PropTypes from 'prop-types';
import React, { useState } from 'react';
import classNames from 'classnames';
import { Legend } from '../../Text';
import { usePrefix } from '../../../internal/usePrefix';
var RadioButtonGroup = /*#__PURE__*/React.forwardRef(function RadioButtonGroup(_ref, ref) {
  var _classNames;

  var children = _ref.children,
      className = _ref.className,
      defaultSelected = _ref.defaultSelected,
      disabled = _ref.disabled,
      _ref$labelPosition = _ref.labelPosition,
      labelPosition = _ref$labelPosition === void 0 ? 'right' : _ref$labelPosition,
      legendText = _ref.legendText,
      name = _ref.name,
      _ref$onChange = _ref.onChange,
      onChange = _ref$onChange === void 0 ? function () {} : _ref$onChange,
      _ref$orientation = _ref.orientation,
      orientation = _ref$orientation === void 0 ? 'horizontal' : _ref$orientation,
      valueSelected = _ref.valueSelected;
  var prefix = usePrefix();

  var _useState = useState(valueSelected !== 'undefined' ? valueSelected : defaultSelected),
      _useState2 = _slicedToArray(_useState, 2),
      selected = _useState2[0],
      setSelected = _useState2[1];

  var _useState3 = useState(selected),
      _useState4 = _slicedToArray(_useState3, 2),
      prevValueSelected = _useState4[0],
      setPrevValueSelected = _useState4[1];
  /**
   * prop + state alignment - getDerivedStateFromProps
   * only update if selected prop changes
   */


  if (prevValueSelected !== valueSelected) {
    setSelected(valueSelected !== 'undefined' ? valueSelected : defaultSelected);
    setPrevValueSelected(valueSelected);
  }

  function getRadioButtons() {
    var mappedChildren = React.Children.map(children, function (radioButton) {
      var value = radioButton.props.value;
      return /*#__PURE__*/React.cloneElement(radioButton, {
        name: name,
        key: value,
        value: value,
        onChange: handleOnChange,
        checked: value === selected
      });
    });
    return mappedChildren;
  }

  function handleOnChange(newSelection, value, evt) {
    if (newSelection !== selected) {
      setSelected(newSelection);
      onChange(newSelection, name, evt);
    }
  }

  var fieldsetClasses = classNames("".concat(prefix, "--radio-button-group"), (_classNames = {}, _defineProperty(_classNames, "".concat(prefix, "--radio-button-group--").concat(orientation), orientation === 'vertical'), _defineProperty(_classNames, "".concat(prefix, "--radio-button-group--label-").concat(labelPosition), labelPosition), _classNames));
  var wrapperClasses = classNames("".concat(prefix, "--form-item"), className);
  return /*#__PURE__*/React.createElement("div", {
    className: wrapperClasses,
    ref: ref
  }, /*#__PURE__*/React.createElement("fieldset", {
    className: fieldsetClasses,
    disabled: disabled
  }, legendText && /*#__PURE__*/React.createElement(Legend, {
    className: "".concat(prefix, "--label")
  }, legendText), getRadioButtons()));
});
RadioButtonGroup.propTypes = {
  /**
   * Provide a collection of <RadioButton> components to render in the group
   */
  children: PropTypes.node,

  /**
   * Provide an optional className to be applied to the container node
   */
  className: PropTypes.string,

  /**
   * Specify the <RadioButton> to be selected by default
   */
  defaultSelected: PropTypes.oneOfType([PropTypes.string, PropTypes.number]),

  /**
   * Specify whether the group is disabled
   */
  disabled: PropTypes.bool,

  /**
   * Provide where label text should be placed
   */
  labelPosition: PropTypes.oneOf(['left', 'right']),

  /**
   * Provide a legend to the RadioButtonGroup input that you are
   * exposing to the user
   */
  legendText: PropTypes.node,

  /**
   * Specify the name of the underlying `<input>` nodes
   */
  name: PropTypes.string.isRequired,

  /**
   * Provide an optional `onChange` hook that is called whenever the value of
   * the group changes
   */
  onChange: PropTypes.func,

  /**
   * Provide where radio buttons should be placed
   */
  orientation: PropTypes.oneOf(['horizontal', 'vertical']),

  /**
   * Specify the value that is currently selected in the group
   */
  valueSelected: PropTypes.oneOfType([PropTypes.string, PropTypes.number])
};
export default RadioButtonGroup;