import _extends from "@babel/runtime/helpers/extends";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["small", "className"];

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import PropTypes from 'prop-types';
import React from 'react';
import cx from 'classnames';
import { settings } from 'carbon-components';
var prefix = settings.prefix;

var SearchSkeleton = function SearchSkeleton(_ref) {
  var _cx;

  var small = _ref.small,
      className = _ref.className,
      rest = _objectWithoutProperties(_ref, _excluded);

  var searchClasses = cx(className, (_cx = {}, _defineProperty(_cx, "".concat(prefix, "--skeleton"), true), _defineProperty(_cx, "".concat(prefix, "--search--xl"), !small), _defineProperty(_cx, "".concat(prefix, "--search--sm"), small), _cx));
  return /*#__PURE__*/React.createElement("div", _extends({
    className: searchClasses
  }, rest), /*#__PURE__*/React.createElement("span", {
    className: "".concat(prefix, "--label")
  }), /*#__PURE__*/React.createElement("div", {
    className: "".concat(prefix, "--search-input")
  }));
};

SearchSkeleton.propTypes = {
  /**
   * Specify an optional className to add.
   */
  className: PropTypes.string,

  /**
   * Specify whether the Search should be a small variant
   */
  small: PropTypes.bool
};
SearchSkeleton.defaultProps = {
  small: false
};
export default SearchSkeleton;