import _extends from "@babel/runtime/helpers/extends";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
import _slicedToArray from "@babel/runtime/helpers/slicedToArray";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["autoComplete", "className", "closeButtonLabelText", "defaultValue", "disabled", "id", "labelText", "light", "onChange", "onClear", "onKeyDown", "placeHolderText", "placeholder", "renderIcon", "role", "size", "small", "type", "value"];

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import { Search16, Close16 } from '@carbon/icons-react';
import cx from 'classnames';
import PropTypes from 'prop-types';
import React, { useRef, useState } from 'react';
import { focus } from '../../../internal/focus';
import { keys, match } from '../../../internal/keyboard';
import { useId } from '../../../internal/useId';
import { usePrefix } from '../../../internal/usePrefix';
import deprecate from '../../../prop-types/deprecate';
import { composeEventHandlers } from '../../../tools/events';

function Search(_ref) {
  var _cx, _cx2;

  var _ref$autoComplete = _ref.autoComplete,
      autoComplete = _ref$autoComplete === void 0 ? 'off' : _ref$autoComplete,
      className = _ref.className,
      _ref$closeButtonLabel = _ref.closeButtonLabelText,
      closeButtonLabelText = _ref$closeButtonLabel === void 0 ? 'Clear search input' : _ref$closeButtonLabel,
      defaultValue = _ref.defaultValue,
      disabled = _ref.disabled,
      id = _ref.id,
      labelText = _ref.labelText,
      light = _ref.light,
      _ref$onChange = _ref.onChange,
      onChange = _ref$onChange === void 0 ? function () {} : _ref$onChange,
      _ref$onClear = _ref.onClear,
      onClear = _ref$onClear === void 0 ? function () {} : _ref$onClear,
      onKeyDown = _ref.onKeyDown,
      placeHolderText = _ref.placeHolderText,
      _ref$placeholder = _ref.placeholder,
      placeholder = _ref$placeholder === void 0 ? '' : _ref$placeholder,
      renderIcon = _ref.renderIcon,
      _ref$role = _ref.role,
      role = _ref$role === void 0 ? 'searchbox' : _ref$role,
      _ref$size = _ref.size,
      size = _ref$size === void 0 ? !small ? 'lg' : 'sm' : _ref$size,
      small = _ref.small,
      _ref$type = _ref.type,
      type = _ref$type === void 0 ? 'text' : _ref$type,
      value = _ref.value,
      rest = _objectWithoutProperties(_ref, _excluded);

  var prefix = usePrefix();
  var input = useRef(null);
  var magnifier = useRef(null);
  var inputId = useId('search-input');
  var uniqueId = id || inputId;
  var searchId = "".concat(uniqueId, "-search");

  var _useState = useState(value || defaultValue || false),
      _useState2 = _slicedToArray(_useState, 2),
      hasContent = _useState2[0],
      setHasContent = _useState2[1];

  var _useState3 = useState(value),
      _useState4 = _slicedToArray(_useState3, 2),
      prevValue = _useState4[0],
      setPrevValue = _useState4[1];

  var searchClasses = cx((_cx = {}, _defineProperty(_cx, "".concat(prefix, "--search"), true), _defineProperty(_cx, "".concat(prefix, "--search--sm"), size === 'sm'), _defineProperty(_cx, "".concat(prefix, "--search--md"), size === 'md'), _defineProperty(_cx, "".concat(prefix, "--search--lg"), size === 'lg'), _defineProperty(_cx, "".concat(prefix, "--search--light"), light), _defineProperty(_cx, "".concat(prefix, "--search--disabled"), disabled), _defineProperty(_cx, className, className), _cx));
  var clearClasses = cx((_cx2 = {}, _defineProperty(_cx2, "".concat(prefix, "--search-close"), true), _defineProperty(_cx2, "".concat(prefix, "--search-close--hidden"), !hasContent), _cx2));

  if (value !== prevValue) {
    setHasContent(!!value);
    setPrevValue(value);
  }

  function clearInput(event) {
    if (!value) {
      input.current.value = '';
      onChange(event);
    } else {
      var clearedEvt = Object.assign({}, event.target, {
        target: {
          value: ''
        }
      });
      onChange(clearedEvt);
    }

    onClear();
    setHasContent(false);
    focus(input);
  }

  function handleChange(event) {
    setHasContent(event.target.value !== '');
  }

  function handleKeyDown(event) {
    if (match(event, keys.Escape)) {
      event.stopPropagation();
      clearInput(event);
    }
  }

  return /*#__PURE__*/React.createElement("div", {
    role: "search",
    "aria-labelledby": searchId,
    className: searchClasses
  }, /*#__PURE__*/React.createElement("div", {
    className: "".concat(prefix, "--search-magnifier"),
    ref: magnifier
  }, /*#__PURE__*/React.createElement(SearchIcon, {
    icon: renderIcon
  })), /*#__PURE__*/React.createElement("label", {
    id: searchId,
    htmlFor: uniqueId,
    className: "".concat(prefix, "--label")
  }, labelText), /*#__PURE__*/React.createElement("input", _extends({}, rest, {
    autoComplete: autoComplete,
    className: "".concat(prefix, "--search-input"),
    defaultValue: defaultValue,
    disabled: disabled,
    role: role,
    ref: input,
    id: uniqueId,
    onChange: composeEventHandlers([onChange, handleChange]),
    onKeyDown: composeEventHandlers([onKeyDown, handleKeyDown]),
    placeholder: placeHolderText || placeholder,
    type: type,
    value: value
  })), /*#__PURE__*/React.createElement("button", {
    "aria-label": closeButtonLabelText,
    className: clearClasses,
    disabled: disabled,
    onClick: clearInput,
    type: "button"
  }, /*#__PURE__*/React.createElement(Close16, null)));
}

Search.propTypes = {
  /**
   * Specify an optional value for the `autocomplete` property on the underlying
   * `<input>`, defaults to "off"
   */
  autoComplete: PropTypes.string,

  /**
   * Specify an optional className to be applied to the container node
   */
  className: PropTypes.string,

  /**
   * Specify a label to be read by screen readers on the "close" button
   */
  closeButtonLabelText: PropTypes.string,

  /**
   * Optionally provide the default value of the `<input>`
   */
  defaultValue: PropTypes.oneOfType([PropTypes.string, PropTypes.number]),

  /**
   * Specify whether the `<input>` should be disabled
   */
  disabled: PropTypes.bool,

  /**
   * Specify a custom `id` for the input
   */
  id: PropTypes.string,

  /**
   * Provide the label text for the Search icon
   */
  labelText: PropTypes.node.isRequired,

  /**
   * Specify light version or default version of this control
   */
  light: PropTypes.bool,

  /**
   * Optional callback called when the search value changes.
   */
  onChange: PropTypes.func,

  /**
   * Optional callback called when the search value is cleared.
   */
  onClear: PropTypes.func,

  /**
   * Provide a handler that is invoked on the key down event for the input
   */
  onKeyDown: PropTypes.func,

  /**
   * Deprecated in favor of `placeholder`
   */
  placeHolderText: deprecate(PropTypes.string, "\nThe prop `placeHolderText` for Search has been deprecated in favor of `placeholder`. Please use `placeholder` instead."),

  /**
   * Provide an optional placeholder text for the Search.
   * Note: if the label and placeholder differ,
   * VoiceOver on Mac will read both
   */
  placeholder: PropTypes.string,

  /**
   * Rendered icon for the Search.
   * Can be a React component class
   */
  renderIcon: PropTypes.oneOfType([PropTypes.func, PropTypes.object]),

  /**
   * Specify the role for the underlying `<input>`, defaults to `searchbox`
   */
  role: PropTypes.string,

  /**
   * Specify the search size
   */
  size: PropTypes.oneOf(['sm', 'md', 'lg', 'xl']),

  /**
   * Specify whether the Search should be a small variant
   */

  /**
   * Specify whether the load was successful
   */
  small: deprecate(PropTypes.bool, "\nThe prop `small` for Search has been deprecated in favor of `size`. Please use `size=\"sm\"` instead."),

  /**
   * Optional prop to specify the type of the `<input>`
   */
  type: PropTypes.string,

  /**
   * Specify the value of the `<input>`
   */
  value: PropTypes.oneOfType([PropTypes.string, PropTypes.number])
};

function SearchIcon(_ref2) {
  var icon = _ref2.icon;
  var prefix = usePrefix();

  if (icon) {
    return /*#__PURE__*/React.cloneElement(icon, {
      className: "".concat(prefix, "--search-magnifier-icon")
    });
  }

  return /*#__PURE__*/React.createElement(Search16, {
    className: "".concat(prefix, "--search-magnifier-icon")
  });
}

SearchIcon.propTypes = {
  /**
   * Rendered icon for the Search. Can be a React component class
   */
  icon: PropTypes.oneOfType([PropTypes.func, PropTypes.object])
};
export default Search;