/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import React from 'react';
import { Stack } from '../Stack';
export default {
  title: 'Layout/Stack',
  component: Stack,
  parameters: {
    controls: {
      hideNoControlsWarning: true
    }
  },
  argTypes: {
    children: {
      table: {
        disable: true
      }
    }
  }
};
export var Default = function Default() {
  return /*#__PURE__*/React.createElement(Stack, {
    gap: 6
  }, /*#__PURE__*/React.createElement("div", null, "Item 1"), /*#__PURE__*/React.createElement("div", null, "Item 2"), /*#__PURE__*/React.createElement("div", null, "Item 3"));
};
export var Horizontal = function Horizontal() {
  return /*#__PURE__*/React.createElement(Stack, {
    gap: 6,
    orientation: "horizontal"
  }, /*#__PURE__*/React.createElement("div", null, "Item 1"), /*#__PURE__*/React.createElement("div", null, "Item 2"), /*#__PURE__*/React.createElement("div", null, "Item 3"));
};

var PlaygroundStory = function PlaygroundStory(props) {
  return /*#__PURE__*/React.createElement(Stack, props, /*#__PURE__*/React.createElement("div", null, "Item 1"), /*#__PURE__*/React.createElement("div", null, "Item 2"), /*#__PURE__*/React.createElement("div", null, "Item 3"));
};

export var Playground = PlaygroundStory.bind({});
Playground.argTypes = {
  gap: {
    options: [1, 2, 3, 4, 5, 6, 7, 8, 9, 10],
    control: {
      type: 'select'
    }
  },
  orientation: {
    options: ['horizontal', 'vertical'],
    control: {
      type: 'select'
    }
  }
};