import _extends from "@babel/runtime/helpers/extends";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
import _slicedToArray from "@babel/runtime/helpers/slicedToArray";
var _excluded = ["className", "selected", "children"];

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import PropTypes from 'prop-types';
import React, { useState, useRef } from 'react';
import classNames from 'classnames';
import { settings } from 'carbon-components';
import { selectorTabbable } from '../../internal/keyboard/navigation';
import useIsomorphicEffect from '../../internal/useIsomorphicEffect';
var prefix = settings.prefix;
/**
 * Determine if the node within the provided ref contains content that is tabbable.
 */

function useTabbableContent(ref) {
  var _useState = useState(false),
      _useState2 = _slicedToArray(_useState, 2),
      hasTabbableContent = _useState2[0],
      setHasTabbableContent = _useState2[1];

  useIsomorphicEffect(function () {
    if (ref.current) {
      setHasTabbableContent(ref.current.querySelector(selectorTabbable));
    }
  });
  return hasTabbableContent;
}

var TabContent = function TabContent(props) {
  var className = props.className,
      selected = props.selected,
      children = props.children,
      other = _objectWithoutProperties(props, _excluded);

  var tabContentClasses = classNames("".concat(prefix, "--tab-content"), _defineProperty({}, className, className));
  var ref = useRef(null);
  var hasTabbableContent = useTabbableContent(ref);
  return /*#__PURE__*/React.createElement("div", _extends({
    role: "tabpanel"
  }, other, {
    className: tabContentClasses,
    selected: selected,
    hidden: !selected,
    ref: ref,
    tabIndex: hasTabbableContent ? undefined : 0
  }), children);
};

TabContent.propTypes = {
  /**
   * Pass in content to render inside of the TabContent
   */
  children: PropTypes.node,

  /**
   * Provide a className for the tab content container
   */
  className: PropTypes.string,

  /**
   * Specify whether the TabContent is selected
   */
  selected: PropTypes.bool
};
TabContent.defaultProps = {
  selected: false
};
export default TabContent;