import _extends from "@babel/runtime/helpers/extends";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["hideLabel", "className"];

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import PropTypes from 'prop-types';
import React from 'react';
import cx from 'classnames';
import { usePrefix } from '../../internal/usePrefix';

var TextAreaSkeleton = function TextAreaSkeleton(_ref) {
  var hideLabel = _ref.hideLabel,
      className = _ref.className,
      rest = _objectWithoutProperties(_ref, _excluded);

  var prefix = usePrefix();
  return /*#__PURE__*/React.createElement("div", _extends({
    className: cx("".concat(prefix, "--form-item"), className)
  }, rest), !hideLabel && /*#__PURE__*/React.createElement("span", {
    className: "".concat(prefix, "--label ").concat(prefix, "--skeleton")
  }), /*#__PURE__*/React.createElement("div", {
    className: "".concat(prefix, "--skeleton ").concat(prefix, "--text-area")
  }));
};

TextAreaSkeleton.propTypes = {
  /**
   * Specify an optional className to add to the form item wrapper.
   */
  className: PropTypes.string,

  /**
   * Specify whether the label should be hidden, or not
   */
  hideLabel: PropTypes.bool
};
export default TextAreaSkeleton;