import _extends from "@babel/runtime/helpers/extends";
import _slicedToArray from "@babel/runtime/helpers/slicedToArray";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["active", "children", "className", "hideLabel", "label", "multiselect", "onSelect", "selected", "size"];

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import React, { useEffect, useRef, useState } from 'react';
import PropTypes from 'prop-types';
import classNames from 'classnames';
import { settings } from 'carbon-components';
import { keys, match, matches } from '../../internal/keyboard';
import uniqueId from '../../tools/uniqueId';
var prefix = settings.prefix;
export default function TreeView(_ref) {
  var prespecifiedActive = _ref.active,
      children = _ref.children,
      className = _ref.className,
      _ref$hideLabel = _ref.hideLabel,
      hideLabel = _ref$hideLabel === void 0 ? false : _ref$hideLabel,
      label = _ref.label,
      multiselect = _ref.multiselect,
      onSelect = _ref.onSelect,
      _ref$selected = _ref.selected,
      preselected = _ref$selected === void 0 ? [] : _ref$selected,
      _ref$size = _ref.size,
      size = _ref$size === void 0 ? 'default' : _ref$size,
      rest = _objectWithoutProperties(_ref, _excluded);

  var _useRef = useRef(rest.id || uniqueId()),
      treeId = _useRef.current;

  var treeClasses = classNames(className, "".concat(prefix, "--tree"), _defineProperty({}, "".concat(prefix, "--tree--").concat(size), size !== 'default'));
  var treeRootRef = useRef(null);
  var treeWalker = useRef(treeRootRef === null || treeRootRef === void 0 ? void 0 : treeRootRef.current);

  var _useState = useState(preselected),
      _useState2 = _slicedToArray(_useState, 2),
      selected = _useState2[0],
      setSelected = _useState2[1];

  var _useState3 = useState(prespecifiedActive),
      _useState4 = _slicedToArray(_useState3, 2),
      active = _useState4[0],
      setActive = _useState4[1];

  function resetNodeTabIndices() {
    var _treeRootRef$current$, _treeRootRef$current;

    Array.prototype.forEach.call((_treeRootRef$current$ = treeRootRef === null || treeRootRef === void 0 ? void 0 : (_treeRootRef$current = treeRootRef.current) === null || _treeRootRef$current === void 0 ? void 0 : _treeRootRef$current.querySelectorAll('[tabIndex="0"]')) !== null && _treeRootRef$current$ !== void 0 ? _treeRootRef$current$ : [], function (item) {
      item.tabIndex = -1;
    });
  }

  function handleTreeSelect(event) {
    var node = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
    var nodeId = node.id;

    if (multiselect && (event.metaKey || event.ctrlKey)) {
      if (!selected.includes(nodeId)) {
        setSelected(selected.concat(nodeId));
      } else {
        setSelected(selected.filter(function (selectedId) {
          return selectedId !== nodeId;
        }));
      }
    } else {
      setSelected([nodeId]);
      setActive(nodeId);
    }

    if (onSelect) {
      onSelect(event, node);
    }
  }

  function handleFocusEvent(event) {
    if (event.type === 'blur') {
      var _treeRootRef$current2;

      var currentFocusedNode = event.relatedTarget,
          prevFocusedNode = event.target;

      if (treeRootRef !== null && treeRootRef !== void 0 && (_treeRootRef$current2 = treeRootRef.current) !== null && _treeRootRef$current2 !== void 0 && _treeRootRef$current2.contains(currentFocusedNode)) {
        prevFocusedNode.tabIndex = -1;
      }
    }

    if (event.type === 'focus') {
      var _treeRootRef$current3;

      resetNodeTabIndices();
      var _prevFocusedNode = event.relatedTarget,
          _currentFocusedNode = event.target;

      if (treeRootRef !== null && treeRootRef !== void 0 && (_treeRootRef$current3 = treeRootRef.current) !== null && _treeRootRef$current3 !== void 0 && _treeRootRef$current3.contains(_prevFocusedNode)) {
        _prevFocusedNode.tabIndex = -1;
      }

      _currentFocusedNode.tabIndex = 0;
    }
  }

  var focusTarget = false;
  var nodesWithProps = React.Children.map(children, function (node) {
    var sharedNodeProps = {
      active: active,
      depth: 0,
      onNodeFocusEvent: handleFocusEvent,
      onTreeSelect: handleTreeSelect,
      selected: selected,
      tabIndex: !node.props.disabled && -1 || null
    };

    if (!focusTarget && !node.props.disabled) {
      sharedNodeProps.tabIndex = 0;
      focusTarget = true;
    }

    if ( /*#__PURE__*/React.isValidElement(node)) {
      return /*#__PURE__*/React.cloneElement(node, sharedNodeProps);
    }
  });

  function handleKeyDown(event) {
    event.stopPropagation();

    if (matches(event, [keys.ArrowUp, keys.ArrowDown])) {
      event.preventDefault();
    }

    treeWalker.current.currentNode = event.target;
    var nextFocusNode;

    if (match(event, keys.ArrowUp)) {
      nextFocusNode = treeWalker.current.previousNode();
    }

    if (match(event, keys.ArrowDown)) {
      nextFocusNode = treeWalker.current.nextNode();
    }

    if (nextFocusNode && nextFocusNode !== event.target) {
      resetNodeTabIndices();
      nextFocusNode.tabIndex = 0;
      nextFocusNode.focus();
    }

    if (rest.onKeyDown) {
      rest.onKeyDown(event);
    }
  }

  useEffect(function () {
    var _treeWalker$current;

    treeWalker.current = (_treeWalker$current = treeWalker.current) !== null && _treeWalker$current !== void 0 ? _treeWalker$current : document.createTreeWalker(treeRootRef === null || treeRootRef === void 0 ? void 0 : treeRootRef.current, NodeFilter.SHOW_ELEMENT, {
      acceptNode: function acceptNode(node) {
        if (node.classList.contains("".concat(prefix, "--tree-node--disabled"))) {
          return NodeFilter.FILTER_REJECT;
        }

        if (node.matches("li.".concat(prefix, "--tree-node"))) {
          return NodeFilter.FILTER_ACCEPT;
        }

        return NodeFilter.FILTER_SKIP;
      }
    });
  }, []);
  useEffect(function () {
    if (preselected.length) {
      setSelected(preselected);
    }

    if (prespecifiedActive) {
      setActive(prespecifiedActive);
    }
  }, [preselected, prespecifiedActive]);
  var labelId = "".concat(treeId, "__label");

  var TreeLabel = function TreeLabel() {
    return !hideLabel && /*#__PURE__*/React.createElement("label", {
      id: labelId,
      className: "".concat(prefix, "--label")
    }, label);
  };

  return /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(TreeLabel, null), /*#__PURE__*/React.createElement("ul", _extends({}, rest, {
    "aria-label": hideLabel ? label : null,
    "aria-labelledby": !hideLabel ? labelId : null,
    "aria-multiselectable": multiselect || null,
    className: treeClasses,
    onKeyDown: handleKeyDown,
    ref: treeRootRef,
    role: "tree"
  }), nodesWithProps));
}
TreeView.propTypes = {
  /**
   * Mark the active node in the tree, represented by its value
   */
  active: PropTypes.oneOfType([PropTypes.string, PropTypes.number]),

  /**
   * Specify the children of the TreeView
   */
  children: PropTypes.node,

  /**
   * Specify an optional className to be applied to the TreeView
   */
  className: PropTypes.string,

  /**
   * Specify whether or not the label should be hidden
   */
  hideLabel: PropTypes.bool,

  /**
   * Provide the label text that will be read by a screen reader
   */
  label: PropTypes.string.isRequired,

  /**
   * Specify the selection mode of the tree.
   * If `multiselect` is `false` then only one node can be selected at a time
   */
  multiselect: PropTypes.bool,

  /**
   * Callback function that is called when any node is selected
   */
  onSelect: PropTypes.func,

  /**
   * Array representing all selected node IDs in the tree
   */
  selected: PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.string, PropTypes.number])),

  /**
   * Specify the size of the tree from a list of available sizes.
   */
  size: PropTypes.oneOf(['default', 'compact'])
};