import _slicedToArray from "@babel/runtime/helpers/slicedToArray";
import _extends from "@babel/runtime/helpers/extends";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["children", "renderIcon", "isExpanded"];

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import React, { useState } from 'react';
import { Document16, Folder16 } from '@carbon/icons-react';
import { InlineNotification } from '../../Notification';
import { default as TreeView, TreeNode } from '../';
import './story.scss';

var props = function props() {
  return {
    active: '5',
    hideLabel: false,
    label: 'Tree view',
    multiselect: false,
    selected: ['5'],
    size: 'default'
  };
};

var nodes = [{
  id: '1',
  value: 'Artificial intelligence',
  label: /*#__PURE__*/React.createElement("span", null, "Artificial intelligence"),
  renderIcon: Document16
}, {
  id: '2',
  value: 'Blockchain',
  label: 'Blockchain',
  renderIcon: Document16
}, {
  id: '3',
  value: 'Business automation',
  label: 'Business automation',
  renderIcon: Folder16,
  children: [{
    id: '3-1',
    value: 'Business process automation',
    label: 'Business process automation',
    renderIcon: Document16
  }, {
    id: '3-2',
    value: 'Business process mapping',
    label: 'Business process mapping',
    renderIcon: Document16
  }]
}, {
  id: '4',
  value: 'Business operations',
  label: 'Business operations',
  renderIcon: Document16
}, {
  id: '5',
  value: 'Cloud computing',
  label: 'Cloud computing',
  isExpanded: true,
  renderIcon: Folder16,
  children: [{
    id: '5-1',
    value: 'Containers',
    label: 'Containers',
    renderIcon: Document16
  }, {
    id: '5-2',
    value: 'Databases',
    label: 'Databases',
    renderIcon: Document16
  }, {
    id: '5-3',
    value: 'DevOps',
    label: 'DevOps',
    isExpanded: true,
    renderIcon: Folder16,
    children: [{
      id: '5-4',
      value: 'Solutions',
      label: 'Solutions',
      renderIcon: Document16
    }, {
      id: '5-5',
      value: 'Case studies',
      label: 'Case studies',
      isExpanded: true,
      renderIcon: Folder16,
      children: [{
        id: '5-6',
        value: 'Resources',
        label: 'Resources',
        renderIcon: Document16
      }]
    }]
  }]
}, {
  id: '6',
  value: 'Data & Analytics',
  label: 'Data & Analytics',
  renderIcon: Folder16,
  children: [{
    id: '6-1',
    value: 'Big data',
    label: 'Big data',
    renderIcon: Document16
  }, {
    id: '6-2',
    value: 'Business intelligence',
    label: 'Business intelligence',
    renderIcon: Document16
  }]
}, {
  id: '7',
  value: 'IT infrastructure',
  label: 'IT infrastructure',
  isExpanded: true,
  disabled: true,
  renderIcon: Folder16,
  children: [{
    id: '7-1',
    value: 'Data storage',
    label: 'Data storage',
    renderIcon: Document16
  }, {
    id: '7-2',
    value: 'Enterprise servers',
    label: 'Enterprise servers',
    renderIcon: Document16
  }, {
    id: '8',
    value: 'Hybrid cloud infrastructure',
    label: 'Hybrid cloud infrastructure',
    isExpanded: true,
    renderIcon: Folder16,
    children: [{
      id: '8-1',
      value: 'Insights',
      label: 'Insights',
      renderIcon: Document16
    }, {
      id: '8-2',
      value: 'Benefits',
      label: 'Benefits',
      renderIcon: Document16
    }]
  }]
}];

function renderTree(_ref) {
  var nodes = _ref.nodes,
      expanded = _ref.expanded,
      _ref$withIcons = _ref.withIcons,
      withIcons = _ref$withIcons === void 0 ? false : _ref$withIcons;

  if (!nodes) {
    return;
  }

  return nodes.map(function (_ref2) {
    var children = _ref2.children,
        renderIcon = _ref2.renderIcon,
        isExpanded = _ref2.isExpanded,
        nodeProps = _objectWithoutProperties(_ref2, _excluded);

    return /*#__PURE__*/React.createElement(TreeNode, _extends({
      key: nodeProps.id,
      renderIcon: withIcons ? renderIcon : null,
      isExpanded: expanded !== null && expanded !== void 0 ? expanded : isExpanded
    }, nodeProps), renderTree({
      nodes: children,
      expanded: expanded,
      withIcons: withIcons
    }));
  });
}

export default {
  title: 'Experimental/unstable_TreeView',
  parameters: {
    component: TreeView
  }
};
export var Default = function Default() {
  return /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(InlineNotification, {
    kind: "info",
    title: "Experimental component",
    subtitle: "An accessibility review of this component is in progress"
  }), /*#__PURE__*/React.createElement(TreeView, props(), renderTree({
    nodes: nodes
  })));
};
Default.storyName = 'default';
Default.parameters = {
  info: {
    text: ""
  }
};
export var WithIcons = function WithIcons() {
  return /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(InlineNotification, {
    kind: "info",
    title: "Experimental component",
    subtitle: "An accessibility review of this component is in progress"
  }), /*#__PURE__*/React.createElement(TreeView, props(), renderTree({
    nodes: nodes,
    withIcons: true
  })));
};
WithIcons.storyName = 'with icons';
export var WithControlledExpansion = function WithControlledExpansion() {
  var _useState = useState(undefined),
      _useState2 = _slicedToArray(_useState, 2),
      expanded = _useState2[0],
      setExpanded = _useState2[1];

  return /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(InlineNotification, {
    kind: "info",
    title: "Experimental component",
    subtitle: "An accessibility review of this component is in progress"
  }), /*#__PURE__*/React.createElement("div", {
    style: {
      marginBottom: '1rem'
    }
  }, /*#__PURE__*/React.createElement("button", {
    type: "button",
    onClick: function onClick() {
      return setExpanded(true);
    }
  }, "expand all"), /*#__PURE__*/React.createElement("button", {
    type: "button",
    onClick: function onClick() {
      return setExpanded(false);
    }
  }, "collapse all")), /*#__PURE__*/React.createElement(TreeView, props(), renderTree({
    nodes: nodes,
    expanded: expanded
  })));
};