import _extends from "@babel/runtime/helpers/extends";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
import _classCallCheck from "@babel/runtime/helpers/classCallCheck";
import _createClass from "@babel/runtime/helpers/createClass";
import _assertThisInitialized from "@babel/runtime/helpers/assertThisInitialized";
import _inherits from "@babel/runtime/helpers/inherits";
import _possibleConstructorReturn from "@babel/runtime/helpers/possibleConstructorReturn";
import _getPrototypeOf from "@babel/runtime/helpers/getPrototypeOf";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
var _excluded = ["aria-label", "aria-labelledby", "children", "className"];

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import cx from 'classnames';
import React from 'react';
import PropTypes from 'prop-types';
import { AriaLabelPropType } from '../../prop-types/AriaPropTypes';
import { PrefixContext } from '../../internal/usePrefix';

var HeaderNavigation = /*#__PURE__*/function (_React$Component) {
  _inherits(HeaderNavigation, _React$Component);

  var _super = _createSuper(HeaderNavigation);

  function HeaderNavigation(props) {
    var _this;

    _classCallCheck(this, HeaderNavigation);

    _this = _super.call(this, props);

    _defineProperty(_assertThisInitialized(_this), "handleItemRef", function (index) {
      return function (node) {
        _this.items[index] = node;
      };
    });

    _defineProperty(_assertThisInitialized(_this), "_renderNavItem", function (child, index) {
      if ( /*#__PURE__*/React.isValidElement(child)) {
        return /*#__PURE__*/React.cloneElement(child, {
          ref: _this.handleItemRef(index)
        });
      }
    });

    _this.items = [];
    _this.state = {
      selectedIndex: 0
    };
    return _this;
  }

  _createClass(HeaderNavigation, [{
    key: "render",
    value: function render() {
      var prefix = this.context;

      var _this$props = this.props,
          ariaLabel = _this$props['aria-label'],
          ariaLabelledBy = _this$props['aria-labelledby'],
          children = _this$props.children,
          customClassName = _this$props.className,
          rest = _objectWithoutProperties(_this$props, _excluded);

      var className = cx("".concat(prefix, "--header__nav"), customClassName); // Assign both label strategies in this option, only one should be defined
      // so when we spread that should be the one that is applied to the node

      var accessibilityLabel = {
        'aria-label': ariaLabel,
        'aria-labelledby': ariaLabelledBy
      };
      return /*#__PURE__*/React.createElement("nav", _extends({}, rest, accessibilityLabel, {
        className: className
      }), /*#__PURE__*/React.createElement("ul", _extends({}, accessibilityLabel, {
        className: "".concat(prefix, "--header__menu-bar")
      }), React.Children.map(children, this._renderNavItem)));
    }
    /**
     * Render an individual menuitem, adding a `ref` for each child inside of
     * `this.items` to properly manage focus.
     */

  }]);

  return HeaderNavigation;
}(React.Component);

_defineProperty(HeaderNavigation, "propTypes", _objectSpread(_objectSpread({}, AriaLabelPropType), {}, {
  /**
   * Provide valid children of HeaderNavigation, for example `HeaderMenuItem`
   * or `HeaderMenu`
   */
  children: PropTypes.node,

  /**
   * Optionally provide a custom class to apply to the underlying <nav> node
   */
  className: PropTypes.string
}));

_defineProperty(HeaderNavigation, "contextType", PrefixContext);

export { HeaderNavigation as default };