"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

require("carbon-components/scss/components/button/_button.scss");

var _react = _interopRequireDefault(require("react"));

var _react2 = require("@cypress/react");

var _Button = _interopRequireDefault(require("../Button"));

var _ButtonSet = _interopRequireDefault(require("./ButtonSet"));

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
describe('ButtonSet', function () {
  beforeEach(function () {
    (0, _react2.mount)( /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_ButtonSet.default, null, /*#__PURE__*/_react.default.createElement(_Button.default, {
      kind: "secondary"
    }, "set-secondary"), /*#__PURE__*/_react.default.createElement(_Button.default, {
      kind: "primary"
    }, "set-primary")), /*#__PURE__*/_react.default.createElement(_ButtonSet.default, {
      stacked: true
    }, /*#__PURE__*/_react.default.createElement(_Button.default, {
      kind: "secondary"
    }, "set-stacked-secondary"), /*#__PURE__*/_react.default.createElement(_Button.default, {
      kind: "primary"
    }, "set-stacked-primary")), /*#__PURE__*/_react.default.createElement(_ButtonSet.default, null, /*#__PURE__*/_react.default.createElement(_Button.default, {
      kind: "secondary",
      isExpressive: true
    }, "set-secondary-expressive"), /*#__PURE__*/_react.default.createElement(_Button.default, {
      kind: "primary",
      isExpressive: true
    }, "set-primary-expressive"))));
  });
  it('should render', function () {
    // full string match regex syntax ^string$ to prevent collisions
    cy.findByText(/^set-secondary$/).should('be.visible');
    cy.findByText(/^set-primary$/).should('be.visible');
    cy.findByText(/^set-stacked-secondary$/).should('be.visible');
    cy.findByText(/^set-stacked-primary$/).should('be.visible');
    cy.findByText(/^set-secondary-expressive$/).should('be.visible');
    cy.findByText(/^set-primary-expressive$/).should('be.visible'); // snapshots should always be taken _after_ an assertion that
    // a element/component should be visible. This is to ensure
    // the DOM has settled and the element has fully loaded.

    cy.percySnapshot();
  });
});