"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ModalHeader = ModalHeader;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _classnames = _interopRequireDefault(require("classnames"));

var _iconsReact = require("@carbon/icons-react");

var _usePrefix = require("../../../internal/usePrefix");

var _excluded = ["buttonOnClick", "children", "className", "closeClassName", "closeIconClassName", "closeModal", "iconDescription", "label", "labelClassName", "title", "titleClassName"];

function ModalHeader(_ref) {
  var _cx, _cx2, _cx3, _cx4, _cx5;

  var buttonOnClick = _ref.buttonOnClick,
      children = _ref.children,
      customClassName = _ref.className,
      closeClassName = _ref.closeClassName,
      closeIconClassName = _ref.closeIconClassName,
      closeModal = _ref.closeModal,
      iconDescription = _ref.iconDescription,
      label = _ref.label,
      labelClassName = _ref.labelClassName,
      title = _ref.title,
      titleClassName = _ref.titleClassName,
      rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var prefix = (0, _usePrefix.usePrefix)();

  function handleCloseButtonClick(evt) {
    closeModal(evt);
    buttonOnClick();
  }

  var headerClass = (0, _classnames.default)((_cx = {}, (0, _defineProperty2.default)(_cx, "".concat(prefix, "--modal-header"), true), (0, _defineProperty2.default)(_cx, customClassName, customClassName), _cx));
  var labelClass = (0, _classnames.default)((_cx2 = {}, (0, _defineProperty2.default)(_cx2, "".concat(prefix, "--modal-header__label ").concat(prefix, "--type-delta"), true), (0, _defineProperty2.default)(_cx2, labelClassName, labelClassName), _cx2));
  var titleClass = (0, _classnames.default)((_cx3 = {}, (0, _defineProperty2.default)(_cx3, "".concat(prefix, "--modal-header__heading ").concat(prefix, "--type-beta"), true), (0, _defineProperty2.default)(_cx3, titleClassName, titleClassName), _cx3));
  var closeClass = (0, _classnames.default)((_cx4 = {}, (0, _defineProperty2.default)(_cx4, "".concat(prefix, "--modal-close"), true), (0, _defineProperty2.default)(_cx4, closeClassName, closeClassName), _cx4));
  var closeIconClass = (0, _classnames.default)((_cx5 = {}, (0, _defineProperty2.default)(_cx5, "".concat(prefix, "--modal-close__icon"), true), (0, _defineProperty2.default)(_cx5, closeIconClassName, closeIconClassName), _cx5));
  return /*#__PURE__*/_react.default.createElement("div", (0, _extends2.default)({
    className: headerClass
  }, rest), label && /*#__PURE__*/_react.default.createElement("h2", {
    className: labelClass
  }, label), title && /*#__PURE__*/_react.default.createElement("h3", {
    className: titleClass
  }, title), children, /*#__PURE__*/_react.default.createElement("button", {
    onClick: handleCloseButtonClick,
    className: closeClass,
    title: iconDescription,
    "aria-label": iconDescription,
    type: "button"
  }, /*#__PURE__*/_react.default.createElement(_iconsReact.Close20, {
    className: closeIconClass
  })));
}

ModalHeader.propTypes = {
  /**
   * Provide an optional function to be called when the close button is
   * clicked
   */
  buttonOnClick: _propTypes.default.func,

  /**
   * Specify the content to be placed in the ModalHeader
   */
  children: _propTypes.default.node,

  /**
   * Specify an optional className to be applied to the modal header
   */
  className: _propTypes.default.string,

  /**
   * Specify an optional className to be applied to the modal close node
   */
  closeClassName: _propTypes.default.string,

  /**
   * Specify an optional className to be applied to the modal close icon node
   */
  closeIconClassName: _propTypes.default.string,

  /**
   * Provide an optional function to be called when the modal is closed
   */
  closeModal: _propTypes.default.func,

  /**
   * Specify a description for the close icon that can be read by screen
   * readers
   */
  iconDescription: _propTypes.default.string,

  /**
   * Specify an optional label to be displayed
   */
  label: _propTypes.default.node,

  /**
   * Specify an optional className to be applied to the modal header label
   */
  labelClassName: _propTypes.default.string,

  /**
   * Specify an optional title to be displayed
   */
  title: _propTypes.default.node,

  /**
   * Specify an optional className to be applied to the modal heading
   */
  titleClassName: _propTypes.default.string
};
ModalHeader.defaultProps = {
  iconDescription: 'Close',
  buttonOnClick: function buttonOnClick() {},
  closeModal: function closeModal() {}
};