"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

var _typeof = require("@babel/runtime/helpers/typeof");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Playground = exports.WithCheckmarkColumns = exports.WithToolbar = exports.WithOverflowMenu = exports.BasicTable = exports.Usage = exports.default = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

require("./stories/datatable-story.scss");

var _addonActions = require("@storybook/addon-actions");

var _react = _interopRequireDefault(require("react"));

var _addonKnobs = require("@storybook/addon-knobs");

var _Button = _interopRequireDefault(require("../Button"));

var _Checkbox = _interopRequireDefault(require("../Checkbox"));

var _OverflowMenu = _interopRequireDefault(require("../OverflowMenu"));

var _OverflowMenuItem = _interopRequireDefault(require("../OverflowMenuItem"));

var _DataTable = _interopRequireWildcard(require("../DataTable"));

var _DataTable2 = _interopRequireDefault(require("./DataTable.mdx"));

var _shared = require("./stories/shared");

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

/**
 * Copyright IBM Corp. 2016, 2020
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
var props = function props() {
  return {
    useZebraStyles: (0, _addonKnobs.boolean)('Zebra row styles (useZebraStyles)', false),
    size: (0, _addonKnobs.select)('Row height (size)', {
      'Extra small (xs)': 'xs',
      'Small (sm)': 'sm',
      'Medium (md)': 'md',
      'Large (lg) - default': 'lg',
      'Extra Large (xl)': 'xl'
    }, 'lg'),
    stickyHeader: (0, _addonKnobs.boolean)('Sticky header (experimental)', false),
    useStaticWidth: (0, _addonKnobs.boolean)('Use static width (useStaticWidth)', false)
  };
};

var _default = {
  title: 'Components/DataTable',
  component: _DataTable.default,
  subcomponents: {
    TableContainer: _DataTable.TableContainer,
    Table: _DataTable.Table,
    TableHead: _DataTable.TableHead,
    TableRow: _DataTable.TableRow,
    TableHeader: _DataTable.TableHeader,
    TableBody: _DataTable.TableBody,
    TableCell: _DataTable.TableCell
  },
  decorators: [_addonKnobs.withKnobs],
  parameters: {
    docs: {
      page: _DataTable2.default
    }
  }
};
exports.default = _default;

var Usage = function Usage() {
  return /*#__PURE__*/_react.default.createElement(_DataTable.default, (0, _extends2.default)({
    rows: _shared.rows,
    headers: _shared.headers
  }, props()), function (_ref) {
    var rows = _ref.rows,
        headers = _ref.headers,
        getHeaderProps = _ref.getHeaderProps,
        getRowProps = _ref.getRowProps,
        getTableProps = _ref.getTableProps,
        getTableContainerProps = _ref.getTableContainerProps;
    return /*#__PURE__*/_react.default.createElement(_DataTable.TableContainer, (0, _extends2.default)({
      title: "DataTable",
      description: "Usage example"
    }, getTableContainerProps()), /*#__PURE__*/_react.default.createElement(_DataTable.Table, (0, _extends2.default)({}, getTableProps(), {
      isSortable: true
    }), /*#__PURE__*/_react.default.createElement(_DataTable.TableHead, null, /*#__PURE__*/_react.default.createElement(_DataTable.TableRow, null, headers.map(function (header) {
      return /*#__PURE__*/_react.default.createElement(_DataTable.TableHeader, (0, _extends2.default)({
        id: header.key,
        key: header.key
      }, getHeaderProps({
        header: header
      }), {
        isSortable: true
      }), header.header);
    }))), /*#__PURE__*/_react.default.createElement(_DataTable.TableBody, null, rows.map(function (row) {
      return /*#__PURE__*/_react.default.createElement(_DataTable.TableRow, (0, _extends2.default)({
        key: row.id
      }, getRowProps({
        row: row
      })), row.cells.map(function (cell) {
        return /*#__PURE__*/_react.default.createElement(_DataTable.TableCell, {
          key: cell.id
        }, cell.value);
      }));
    }))));
  });
};

exports.Usage = Usage;

var BasicTable = function BasicTable() {
  var rows = [{
    id: 'load-balancer-1',
    name: 'Load Balancer 1',
    rule: 'Round robin',
    Status: 'Starting'
  }, {
    id: 'load-balancer-2',
    name: 'Load Balancer 2',
    rule: 'DNS delegation',
    status: 'Active'
  }, {
    id: 'load-balancer-3',
    name: 'Load Balancer 3',
    rule: 'Round robin',
    status: 'Disabled'
  }];
  var headers = ['Name', 'Rule', 'Status'];
  return /*#__PURE__*/_react.default.createElement(_DataTable.Table, null, /*#__PURE__*/_react.default.createElement(_DataTable.TableHead, null, /*#__PURE__*/_react.default.createElement(_DataTable.TableRow, null, headers.map(function (header) {
    return /*#__PURE__*/_react.default.createElement(_DataTable.TableHeader, {
      id: header.key,
      key: header
    }, header);
  }))), /*#__PURE__*/_react.default.createElement(_DataTable.TableBody, null, rows.map(function (row) {
    return /*#__PURE__*/_react.default.createElement(_DataTable.TableRow, {
      key: row.id
    }, Object.keys(row).filter(function (key) {
      return key !== 'id';
    }).map(function (key) {
      return /*#__PURE__*/_react.default.createElement(_DataTable.TableCell, {
        key: key
      }, row[key]);
    }));
  })));
};

exports.BasicTable = BasicTable;

var WithOverflowMenu = function WithOverflowMenu() {
  return /*#__PURE__*/_react.default.createElement(_DataTable.default, (0, _extends2.default)({
    rows: _shared.rows,
    headers: _shared.headers
  }, props()), function (_ref2) {
    var rows = _ref2.rows,
        headers = _ref2.headers,
        getHeaderProps = _ref2.getHeaderProps,
        getRowProps = _ref2.getRowProps,
        getTableProps = _ref2.getTableProps;
    return /*#__PURE__*/_react.default.createElement(_DataTable.TableContainer, {
      title: "DataTable",
      description: "With overflow menu"
    }, /*#__PURE__*/_react.default.createElement(_DataTable.Table, getTableProps(), /*#__PURE__*/_react.default.createElement(_DataTable.TableHead, null, /*#__PURE__*/_react.default.createElement(_DataTable.TableRow, null, headers.map(function (header) {
      return /*#__PURE__*/_react.default.createElement(_DataTable.TableHeader, (0, _extends2.default)({
        key: header.key
      }, getHeaderProps({
        header: header
      })), header.header);
    }), /*#__PURE__*/_react.default.createElement(_DataTable.TableHeader, null))), /*#__PURE__*/_react.default.createElement(_DataTable.TableBody, null, rows.map(function (row) {
      return /*#__PURE__*/_react.default.createElement(_DataTable.TableRow, (0, _extends2.default)({
        key: row.id
      }, getRowProps({
        row: row
      })), row.cells.map(function (cell) {
        return /*#__PURE__*/_react.default.createElement(_DataTable.TableCell, {
          key: cell.id
        }, cell.value);
      }), /*#__PURE__*/_react.default.createElement(_DataTable.TableCell, {
        className: "bx--table-column-menu"
      }, /*#__PURE__*/_react.default.createElement(_OverflowMenu.default, {
        size: "sm",
        light: true,
        flipped: true
      }, /*#__PURE__*/_react.default.createElement(_OverflowMenuItem.default, null, "Action 1"), /*#__PURE__*/_react.default.createElement(_OverflowMenuItem.default, null, "Action 2"), /*#__PURE__*/_react.default.createElement(_OverflowMenuItem.default, null, "Action 3"))));
    }))));
  });
};

exports.WithOverflowMenu = WithOverflowMenu;

var WithToolbar = function WithToolbar() {
  return /*#__PURE__*/_react.default.createElement(_DataTable.default, (0, _extends2.default)({
    rows: _shared.rows,
    headers: _shared.headers
  }, props()), function (_ref3) {
    var rows = _ref3.rows,
        headers = _ref3.headers,
        getHeaderProps = _ref3.getHeaderProps,
        getRowProps = _ref3.getRowProps,
        getTableProps = _ref3.getTableProps,
        getToolbarProps = _ref3.getToolbarProps,
        onInputChange = _ref3.onInputChange,
        getTableContainerProps = _ref3.getTableContainerProps;
    return /*#__PURE__*/_react.default.createElement(_DataTable.TableContainer, (0, _extends2.default)({
      title: "DataTable",
      description: "With toolbar"
    }, getTableContainerProps()), /*#__PURE__*/_react.default.createElement(_DataTable.TableToolbar, (0, _extends2.default)({}, getToolbarProps(), {
      "aria-label": "data table toolbar"
    }), /*#__PURE__*/_react.default.createElement(_DataTable.TableToolbarContent, null, /*#__PURE__*/_react.default.createElement(_DataTable.TableToolbarSearch, {
      onChange: onInputChange,
      onClear: (0, _addonActions.action)('onClear'),
      onFocus: function onFocus(event, handleExpand) {
        (0, _addonActions.action)('onFocus')();
        handleExpand(event, true);
      },
      onBlur: function onBlur(event, handleExpand) {
        (0, _addonActions.action)('onBlur')();
        var value = event.target.value;

        if (!value) {
          handleExpand(event, false);
        }
      }
    }), /*#__PURE__*/_react.default.createElement(_DataTable.TableToolbarMenu, {
      light: true
    }, /*#__PURE__*/_react.default.createElement(_DataTable.TableToolbarAction, {
      onClick: (0, _addonActions.action)('Action 1 Click')
    }, "Action 1"), /*#__PURE__*/_react.default.createElement(_DataTable.TableToolbarAction, {
      onClick: (0, _addonActions.action)('Action 2 Click')
    }, "Action 2"), /*#__PURE__*/_react.default.createElement(_DataTable.TableToolbarAction, {
      onClick: (0, _addonActions.action)('Action 3 Click')
    }, "Action 3")), /*#__PURE__*/_react.default.createElement(_Button.default, {
      onClick: (0, _addonActions.action)('Button click')
    }, "Primary Button"))), /*#__PURE__*/_react.default.createElement(_DataTable.Table, getTableProps(), /*#__PURE__*/_react.default.createElement(_DataTable.TableHead, null, /*#__PURE__*/_react.default.createElement(_DataTable.TableRow, null, headers.map(function (header) {
      return /*#__PURE__*/_react.default.createElement(_DataTable.TableHeader, (0, _extends2.default)({
        key: header.key
      }, getHeaderProps({
        header: header
      })), header.header);
    }))), /*#__PURE__*/_react.default.createElement(_DataTable.TableBody, null, rows.map(function (row) {
      return /*#__PURE__*/_react.default.createElement(_DataTable.TableRow, (0, _extends2.default)({
        key: row.id
      }, getRowProps({
        row: row
      })), row.cells.map(function (cell) {
        return /*#__PURE__*/_react.default.createElement(_DataTable.TableCell, {
          key: cell.id
        }, cell.value);
      }));
    }))));
  });
};

exports.WithToolbar = WithToolbar;

var WithCheckmarkColumns = function WithCheckmarkColumns() {
  var rows = [{
    id: 'a',
    name: 'Load Balancer 3',
    protocol: 'HTTP',
    port: 3000,
    rule: 'Round robin',
    attached_groups: 'Kevin’s VM Groups',
    status: 'Disabled',
    enabled: true
  }, {
    id: 'b',
    name: 'Load Balancer 1',
    protocol: 'HTTP',
    port: 443,
    rule: 'Round robin',
    attached_groups: 'Maureen’s VM Groups',
    status: 'Starting',
    enabled: true
  }, {
    id: 'c',
    name: 'Load Balancer 2',
    protocol: 'HTTP',
    port: 80,
    rule: 'DNS delegation',
    attached_groups: 'Andrew’s VM Groups',
    status: 'Active',
    enabled: false
  }];
  var headers = [{
    key: 'name',
    header: 'Name'
  }, {
    key: 'protocol',
    header: 'Protocol'
  }, {
    key: 'port',
    header: 'Port'
  }, {
    key: 'rule',
    header: 'Rule'
  }, {
    key: 'attached_groups',
    header: 'Attached Groups'
  }, {
    key: 'status',
    header: 'Status'
  }, {
    key: 'enabled',
    header: 'Enabled'
  }];
  return /*#__PURE__*/_react.default.createElement(_DataTable.default, (0, _extends2.default)({
    rows: rows,
    headers: headers
  }, props()), function (_ref4) {
    var rows = _ref4.rows,
        headers = _ref4.headers,
        getHeaderProps = _ref4.getHeaderProps,
        getRowProps = _ref4.getRowProps,
        getTableProps = _ref4.getTableProps,
        getTableContainerProps = _ref4.getTableContainerProps;
    return /*#__PURE__*/_react.default.createElement(_DataTable.TableContainer, (0, _extends2.default)({
      title: "DataTable",
      description: "With boolean column"
    }, getTableContainerProps()), /*#__PURE__*/_react.default.createElement(_DataTable.Table, getTableProps(), /*#__PURE__*/_react.default.createElement(_DataTable.TableHead, null, /*#__PURE__*/_react.default.createElement(_DataTable.TableRow, null, headers.map(function (header) {
      return /*#__PURE__*/_react.default.createElement(_DataTable.TableHeader, (0, _extends2.default)({
        key: header.key
      }, getHeaderProps({
        header: header
      })), header.header);
    }))), /*#__PURE__*/_react.default.createElement(_DataTable.TableBody, null, rows.map(function (row) {
      return /*#__PURE__*/_react.default.createElement(_DataTable.TableRow, (0, _extends2.default)({
        key: row.id
      }, getRowProps({
        row: row
      })), row.cells.map(function (cell) {
        if (cell.info.header === 'enabled') {
          return /*#__PURE__*/_react.default.createElement(_DataTable.TableCell, {
            key: cell.id,
            id: cell.id,
            className: "la-".concat(cell.info.header)
          }, /*#__PURE__*/_react.default.createElement(_Checkbox.default, {
            id: 'check-' + cell.id,
            hideLabel: true,
            labelText: "checkbox"
          }));
        } else {
          return /*#__PURE__*/_react.default.createElement(_DataTable.TableCell, {
            key: cell.id
          }, cell.value);
        }
      }));
    }))));
  });
};

exports.WithCheckmarkColumns = WithCheckmarkColumns;

var Playground = function Playground() {
  return /*#__PURE__*/_react.default.createElement(_DataTable.default, (0, _extends2.default)({
    rows: _shared.rows,
    headers: _shared.headers
  }, props(), {
    render: function render(_ref5) {
      var rows = _ref5.rows,
          headers = _ref5.headers,
          getHeaderProps = _ref5.getHeaderProps,
          getRowProps = _ref5.getRowProps,
          getTableProps = _ref5.getTableProps,
          getTableContainerProps = _ref5.getTableContainerProps;
      return /*#__PURE__*/_react.default.createElement(_DataTable.TableContainer, (0, _extends2.default)({
        title: "DataTable",
        description: "With default options"
      }, getTableContainerProps()), /*#__PURE__*/_react.default.createElement(_DataTable.Table, getTableProps(), /*#__PURE__*/_react.default.createElement(_DataTable.TableHead, null, /*#__PURE__*/_react.default.createElement(_DataTable.TableRow, null, headers.map(function (header, i) {
        return /*#__PURE__*/_react.default.createElement(_DataTable.TableHeader, (0, _extends2.default)({
          id: header.key,
          key: i
        }, getHeaderProps({
          header: header
        })), header.header);
      }))), /*#__PURE__*/_react.default.createElement(_DataTable.TableBody, null, rows.map(function (row, i) {
        return /*#__PURE__*/_react.default.createElement(_DataTable.TableRow, (0, _extends2.default)({
          key: i
        }, getRowProps({
          row: row
        })), row.cells.map(function (cell) {
          return /*#__PURE__*/_react.default.createElement(_DataTable.TableCell, {
            key: cell.id
          }, cell.value);
        }));
      }))));
    }
  }));
};

exports.Playground = Playground;