"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _classnames = _interopRequireDefault(require("classnames"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _react = _interopRequireDefault(require("react"));

var _iconsReact = require("@carbon/icons-react");

var _carbonComponents = require("carbon-components");

var _TableCell = _interopRequireDefault(require("./TableCell"));

var _excluded = ["ariaLabel", "className", "children", "isExpanded", "onExpand", "expandIconDescription", "isSelected", "expandHeader"];
var prefix = _carbonComponents.settings.prefix;

var TableExpandRow = function TableExpandRow(_ref) {
  var _cx;

  var ariaLabel = _ref.ariaLabel,
      rowClassName = _ref.className,
      children = _ref.children,
      isExpanded = _ref.isExpanded,
      onExpand = _ref.onExpand,
      expandIconDescription = _ref.expandIconDescription,
      isSelected = _ref.isSelected,
      expandHeader = _ref.expandHeader,
      rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var className = (0, _classnames.default)((_cx = {}, (0, _defineProperty2.default)(_cx, "".concat(prefix, "--parent-row"), true), (0, _defineProperty2.default)(_cx, "".concat(prefix, "--expandable-row"), isExpanded), (0, _defineProperty2.default)(_cx, "".concat(prefix, "--data-table--selected"), isSelected), _cx), rowClassName);
  var previousValue = isExpanded ? 'collapsed' : undefined;
  return /*#__PURE__*/_react.default.createElement("tr", (0, _extends2.default)({}, rest, {
    className: className,
    "data-parent-row": true
  }), /*#__PURE__*/_react.default.createElement(_TableCell.default, {
    className: "".concat(prefix, "--table-expand"),
    "data-previous-value": previousValue,
    headers: expandHeader
  }, /*#__PURE__*/_react.default.createElement("button", {
    type: "button",
    className: "".concat(prefix, "--table-expand__button"),
    onClick: onExpand,
    title: expandIconDescription,
    "aria-label": ariaLabel
  }, /*#__PURE__*/_react.default.createElement(_iconsReact.ChevronRight16, {
    className: "".concat(prefix, "--table-expand__svg"),
    "aria-label": expandIconDescription
  }))), children);
};

TableExpandRow.propTypes = {
  /**
   * Specify the string read by a voice reader when the expand trigger is
   * focused
   */
  ariaLabel: _propTypes.default.string.isRequired,
  children: _propTypes.default.node,
  className: _propTypes.default.string,

  /**
   * The id of the matching th node in the table head. Addresses a11y concerns outlined here: https://www.ibm.com/able/guidelines/ci162/info_and_relationships.html and https://www.w3.org/TR/WCAG20-TECHS/H43
   */
  expandHeader: _propTypes.default.string,

  /**
   * The description of the chevron right icon, to be put in its SVG `<title>` element.
   */
  expandIconDescription: _propTypes.default.string,

  /**
   * Specify whether this row is expanded or not. This helps coordinate data
   * attributes so that `TableExpandRow` and `TableExpandedRow` work together
   */
  isExpanded: _propTypes.default.bool.isRequired,

  /**
   * Specify if the row is selected
   */
  isSelected: _propTypes.default.bool,

  /**
   * Hook for when a listener initiates a request to expand the given row
   */
  onExpand: _propTypes.default.func.isRequired
};
TableExpandRow.defaultProps = {
  expandHeader: 'expand'
};
var _default = TableExpandRow;
exports.default = _default;