"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

var _typeof = require("@babel/runtime/helpers/typeof");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _classnames = _interopRequireDefault(require("classnames"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _react = _interopRequireWildcard(require("react"));

var _carbonComponents = require("carbon-components");

var _Search = _interopRequireDefault(require("../Search"));

var _instanceId = _interopRequireDefault(require("./tools/instanceId"));

var _deprecate = _interopRequireDefault(require("../../prop-types/deprecate"));

var _excluded = ["className", "searchContainerClass", "onChange", "onClear", "translateWithId", "placeHolderText", "placeholder", "labelText", "expanded", "defaultExpanded", "defaultValue", "disabled", "onExpand", "persistent", "persistant", "id", "onBlur", "onFocus"];

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

var prefix = _carbonComponents.settings.prefix;
var getInstanceId = (0, _instanceId.default)();
var translationKeys = {
  'carbon.table.toolbar.search.label': 'Filter table',
  'carbon.table.toolbar.search.placeholder': 'Filter table'
};

var translateWithId = function translateWithId(id) {
  return translationKeys[id];
};

var TableToolbarSearch = function TableToolbarSearch(_ref) {
  var _cx;

  var className = _ref.className,
      searchContainerClass = _ref.searchContainerClass,
      onChangeProp = _ref.onChange,
      onClear = _ref.onClear,
      t = _ref.translateWithId,
      placeHolderText = _ref.placeHolderText,
      placeholder = _ref.placeholder,
      labelText = _ref.labelText,
      expandedProp = _ref.expanded,
      defaultExpanded = _ref.defaultExpanded,
      defaultValue = _ref.defaultValue,
      disabled = _ref.disabled,
      onExpand = _ref.onExpand,
      persistent = _ref.persistent,
      persistant = _ref.persistant,
      id = _ref.id,
      onBlur = _ref.onBlur,
      onFocus = _ref.onFocus,
      rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);

  var _useRef = (0, _react.useRef)(expandedProp !== undefined),
      controlled = _useRef.current;

  var _useState = (0, _react.useState)(defaultExpanded || defaultValue),
      _useState2 = (0, _slicedToArray2.default)(_useState, 2),
      expandedState = _useState2[0],
      setExpandedState = _useState2[1];

  var expanded = controlled ? expandedProp : expandedState;

  var _useState3 = (0, _react.useState)(defaultValue || ''),
      _useState4 = (0, _slicedToArray2.default)(_useState3, 2),
      value = _useState4[0],
      setValue = _useState4[1];

  var uniqueId = (0, _react.useMemo)(getInstanceId, []);

  var _useState5 = (0, _react.useState)(null),
      _useState6 = (0, _slicedToArray2.default)(_useState5, 2),
      focusTarget = _useState6[0],
      setFocusTarget = _useState6[1];

  (0, _react.useEffect)(function () {
    if (focusTarget) {
      focusTarget.current.querySelector('input').focus();
      setFocusTarget(null);
    }
  }, [focusTarget]);
  (0, _react.useEffect)(function () {
    if (defaultValue) {
      onChangeProp('', defaultValue);
    }
  }, //eslint-disable-next-line react-hooks/exhaustive-deps
  []);
  var searchClasses = (0, _classnames.default)(className, (_cx = {}, (0, _defineProperty2.default)(_cx, searchContainerClass, searchContainerClass), (0, _defineProperty2.default)(_cx, "".concat(prefix, "--toolbar-search-container-active"), expanded), (0, _defineProperty2.default)(_cx, "".concat(prefix, "--toolbar-search-container-disabled"), disabled), (0, _defineProperty2.default)(_cx, "".concat(prefix, "--toolbar-search-container-expandable"), !persistent || !persistent && !persistant), (0, _defineProperty2.default)(_cx, "".concat(prefix, "--toolbar-search-container-persistent"), persistent || persistant), _cx));

  var handleExpand = function handleExpand(event) {
    var value = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : !expanded;

    if (!disabled) {
      if (!controlled && (!persistent || !persistent && !persistant)) {
        setExpandedState(value);
      }

      if (onExpand) {
        onExpand(event, value);
      }
    }
  };

  var onChange = function onChange(e) {
    setValue(e.target.value);

    if (onChangeProp) {
      onChangeProp(e);
    }
  };

  var handleOnFocus = function handleOnFocus(event) {
    return handleExpand(event, true);
  };

  var handleOnBlur = function handleOnBlur(event) {
    return !value && handleExpand(event, false);
  };

  return /*#__PURE__*/_react.default.createElement(_Search.default, (0, _extends2.default)({
    disabled: disabled,
    className: searchClasses,
    value: value,
    id: typeof id !== 'undefined' ? id : uniqueId.toString(),
    labelText: labelText || t('carbon.table.toolbar.search.label'),
    placeholder: placeHolderText || placeholder || t('carbon.table.toolbar.search.placeholder'),
    onChange: onChange,
    onClear: onClear,
    onFocus: onFocus ? function (event) {
      return onFocus(event, handleExpand);
    } : handleOnFocus,
    onBlur: onBlur ? function (event) {
      return onBlur(event, handleExpand);
    } : handleOnBlur
  }, rest));
};

TableToolbarSearch.propTypes = {
  children: _propTypes.default.node,

  /**
   * Provide an optional class name for the search container
   */
  className: _propTypes.default.string,

  /**
   * Specifies if the search should initially render in an expanded state
   */
  defaultExpanded: _propTypes.default.bool,

  /**
   * Provide an optional default value for the Search component
   */
  defaultValue: _propTypes.default.string,

  /**
   * Specifies if the search should be disabled
   */
  disabled: _propTypes.default.bool,

  /**
   * Specifies if the search should expand
   */
  expanded: _propTypes.default.bool,

  /**
   * Provide an optional id for the search container
   */
  id: _propTypes.default.string,

  /**
   * Provide an optional label text for the Search component icon
   */
  labelText: _propTypes.default.string,

  /**
   * Provide an optional function to be called when the search input loses focus, this will be
   * passed the event as the first parameter and a function to handle the expanding of the search
   * input as the second
   */
  onBlur: _propTypes.default.func,

  /**
   * Provide an optional hook that is called each time the input is updated
   */
  onChange: _propTypes.default.func,

  /**
   * Optional callback called when the search value is cleared.
   */
  onClear: _propTypes.default.func,

  /**
   * Provide an optional hook that is called each time the input is expanded
   */
  onExpand: _propTypes.default.func,

  /**
   * Provide an optional function to be called when the search input gains focus, this will be
   * passed the event as the first parameter and a function to handle the expanding of the search
   * input as the second.
   */
  onFocus: _propTypes.default.func,
  persistant: (0, _deprecate.default)(_propTypes.default.bool, "\nThe prop `persistant` for TableToolbarSearch has been deprecated in favor of `persistent`. Please use `persistent` instead."),

  /**
   * Whether the search should be allowed to expand
   */
  persistent: _propTypes.default.bool,

  /**
   * Deprecated in favor of `placeholder`
   */
  placeHolderText: (0, _deprecate.default)(_propTypes.default.string, "\nThe prop `placeHolderText` for TableToolbarSearch has been deprecated in favor of `placeholder`. Please use `placeholder` instead."),

  /**
   * Provide an optional placeholder text for the Search component
   */
  placeholder: _propTypes.default.string,

  /**
   * Provide an optional className for the overall container of the Search
   */
  searchContainerClass: _propTypes.default.string,

  /**
   * Optional prop to specify the tabIndex of the <Search> (in expanded state) or the container (in collapsed state)
   */
  tabIndex: _propTypes.default.oneOfType([_propTypes.default.number, _propTypes.default.string]),

  /**
   * Provide custom text for the component for each translation id
   */
  translateWithId: _propTypes.default.func.isRequired
};
TableToolbarSearch.defaultProps = {
  tabIndex: '0',
  translateWithId: translateWithId,
  persistent: false,
  onClear: function onClear() {}
};
var _default = TableToolbarSearch;
exports.default = _default;