"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

var _typeof = require("@babel/runtime/helpers/typeof");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _react = _interopRequireWildcard(require("react"));

var _downshift = require("downshift");

var _classnames = _interopRequireDefault(require("classnames"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _iconsReact = require("@carbon/icons-react");

var _ListBox = _interopRequireWildcard(require("../ListBox"));

var _createPropAdapter = require("../../tools/createPropAdapter");

var _mergeRefs = _interopRequireDefault(require("../../tools/mergeRefs"));

var _deprecate = _interopRequireDefault(require("../../prop-types/deprecate"));

var _FeatureFlags = require("../FeatureFlags");

var _usePrefix = require("../../internal/usePrefix");

var _excluded = ["className", "disabled", "direction", "items", "label", "ariaLabel", "itemToString", "itemToElement", "renderSelectedItem", "type", "size", "onChange", "id", "titleText", "hideLabel", "helperText", "translateWithId", "light", "invalid", "invalidText", "warn", "warnText", "initialSelectedItem", "selectedItem", "downshiftProps"];

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { (0, _defineProperty2.default)(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

var defaultItemToString = function defaultItemToString(item) {
  if (typeof item === 'string') {
    return item;
  }

  return item ? item.label : '';
};

var Dropdown = /*#__PURE__*/_react.default.forwardRef(function Dropdown(_ref, ref) {
  var _cx, _cx2, _cx4;

  var containerClassName = _ref.className,
      disabled = _ref.disabled,
      direction = _ref.direction,
      items = _ref.items,
      label = _ref.label,
      ariaLabel = _ref.ariaLabel,
      itemToString = _ref.itemToString,
      itemToElement = _ref.itemToElement,
      renderSelectedItem = _ref.renderSelectedItem,
      type = _ref.type,
      size = _ref.size,
      onChange = _ref.onChange,
      id = _ref.id,
      titleText = _ref.titleText,
      hideLabel = _ref.hideLabel,
      helperText = _ref.helperText,
      translateWithId = _ref.translateWithId,
      light = _ref.light,
      invalid = _ref.invalid,
      invalidText = _ref.invalidText,
      warn = _ref.warn,
      warnText = _ref.warnText,
      initialSelectedItem = _ref.initialSelectedItem,
      controlledSelectedItem = _ref.selectedItem,
      downshiftProps = _ref.downshiftProps,
      other = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var prefix = (0, _usePrefix.usePrefix)();
  var selectProps = (0, _createPropAdapter.mapDownshiftProps)(_objectSpread(_objectSpread({}, downshiftProps), {}, {
    items: items,
    itemToString: itemToString,
    initialSelectedItem: initialSelectedItem,
    onSelectedItemChange: onSelectedItemChange
  })); // only set selectedItem if the prop is defined. Setting if it is undefined
  // will overwrite default selected items from useSelect

  if (controlledSelectedItem !== undefined) {
    selectProps.selectedItem = controlledSelectedItem;
  }

  var _useSelect = (0, _downshift.useSelect)(selectProps),
      isOpen = _useSelect.isOpen,
      getToggleButtonProps = _useSelect.getToggleButtonProps,
      getLabelProps = _useSelect.getLabelProps,
      getMenuProps = _useSelect.getMenuProps,
      getItemProps = _useSelect.getItemProps,
      highlightedIndex = _useSelect.highlightedIndex,
      selectedItem = _useSelect.selectedItem;

  var inline = type === 'inline';
  var showWarning = !invalid && warn;
  var enabled = (0, _FeatureFlags.useFeatureFlag)('enable-v11-release');
  var className = (0, _classnames.default)("".concat(prefix, "--dropdown"), [enabled ? null : containerClassName], (_cx = {}, (0, _defineProperty2.default)(_cx, "".concat(prefix, "--dropdown--invalid"), invalid), (0, _defineProperty2.default)(_cx, "".concat(prefix, "--dropdown--warning"), showWarning), (0, _defineProperty2.default)(_cx, "".concat(prefix, "--dropdown--open"), isOpen), (0, _defineProperty2.default)(_cx, "".concat(prefix, "--dropdown--inline"), inline), (0, _defineProperty2.default)(_cx, "".concat(prefix, "--dropdown--disabled"), disabled), (0, _defineProperty2.default)(_cx, "".concat(prefix, "--dropdown--light"), light), (0, _defineProperty2.default)(_cx, "".concat(prefix, "--dropdown--").concat(size), size), (0, _defineProperty2.default)(_cx, "".concat(prefix, "--list-box--up"), direction === 'top'), _cx));
  var titleClasses = (0, _classnames.default)("".concat(prefix, "--label"), (_cx2 = {}, (0, _defineProperty2.default)(_cx2, "".concat(prefix, "--label--disabled"), disabled), (0, _defineProperty2.default)(_cx2, "".concat(prefix, "--visually-hidden"), hideLabel), _cx2));
  var helperClasses = (0, _classnames.default)("".concat(prefix, "--form__helper-text"), (0, _defineProperty2.default)({}, "".concat(prefix, "--form__helper-text--disabled"), disabled));
  var wrapperClasses = (0, _classnames.default)("".concat(prefix, "--dropdown__wrapper"), "".concat(prefix, "--list-box__wrapper"), [enabled ? containerClassName : null], (_cx4 = {}, (0, _defineProperty2.default)(_cx4, "".concat(prefix, "--dropdown__wrapper--inline"), inline), (0, _defineProperty2.default)(_cx4, "".concat(prefix, "--list-box__wrapper--inline"), inline), (0, _defineProperty2.default)(_cx4, "".concat(prefix, "--dropdown__wrapper--inline--invalid"), inline && invalid), (0, _defineProperty2.default)(_cx4, "".concat(prefix, "--list-box__wrapper--inline--invalid"), inline && invalid), _cx4)); // needs to be Capitalized for react to render it correctly

  var ItemToElement = itemToElement;
  var toggleButtonProps = getToggleButtonProps();
  var helper = helperText ? /*#__PURE__*/_react.default.createElement("div", {
    className: helperClasses
  }, helperText) : null;

  function onSelectedItemChange(_ref2) {
    var selectedItem = _ref2.selectedItem;

    if (onChange) {
      onChange({
        selectedItem: selectedItem
      });
    }
  }

  var menuItemOptionRefs = (0, _react.useRef)(items.map(function (_) {
    return /*#__PURE__*/_react.default.createRef();
  }));
  return /*#__PURE__*/_react.default.createElement("div", (0, _extends2.default)({
    className: wrapperClasses
  }, other), titleText && /*#__PURE__*/_react.default.createElement("label", (0, _extends2.default)({
    className: titleClasses
  }, getLabelProps()), titleText), /*#__PURE__*/_react.default.createElement(_ListBox.default, {
    "aria-label": ariaLabel,
    size: size,
    className: className,
    invalid: invalid,
    invalidText: invalidText,
    warn: warn,
    warnText: warnText,
    light: light,
    isOpen: isOpen,
    id: id
  }, invalid && /*#__PURE__*/_react.default.createElement(_iconsReact.WarningFilled16, {
    className: "".concat(prefix, "--list-box__invalid-icon")
  }), showWarning && /*#__PURE__*/_react.default.createElement(_iconsReact.WarningAltFilled16, {
    className: "".concat(prefix, "--list-box__invalid-icon ").concat(prefix, "--list-box__invalid-icon--warning")
  }), /*#__PURE__*/_react.default.createElement("button", (0, _extends2.default)({
    type: "button",
    className: "".concat(prefix, "--list-box__field"),
    disabled: disabled,
    "aria-disabled": disabled,
    title: selectedItem ? itemToString(selectedItem) : label
  }, toggleButtonProps, {
    ref: (0, _mergeRefs.default)(toggleButtonProps.ref, ref)
  }), /*#__PURE__*/_react.default.createElement("span", {
    className: "".concat(prefix, "--list-box__label")
  }, selectedItem ? renderSelectedItem ? renderSelectedItem(selectedItem) : itemToString(selectedItem) : label), /*#__PURE__*/_react.default.createElement(_ListBox.default.MenuIcon, {
    isOpen: isOpen,
    translateWithId: translateWithId
  })), /*#__PURE__*/_react.default.createElement(_ListBox.default.Menu, getMenuProps(), isOpen && items.map(function (item, index) {
    var _menuItemOptionRefs$c;

    var itemProps = getItemProps({
      item: item,
      index: index,
      disabled: item.disabled
    });
    var title = itemToElement ? item.text : itemToString(item);

    var _ref3 = (menuItemOptionRefs === null || menuItemOptionRefs === void 0 ? void 0 : (_menuItemOptionRefs$c = menuItemOptionRefs.current[index]) === null || _menuItemOptionRefs$c === void 0 ? void 0 : _menuItemOptionRefs$c.current) || {},
        offsetWidth = _ref3.offsetWidth,
        scrollWidth = _ref3.scrollWidth;

    return /*#__PURE__*/_react.default.createElement(_ListBox.default.MenuItem, (0, _extends2.default)({
      key: itemProps.id,
      isActive: selectedItem === item,
      isHighlighted: highlightedIndex === index || selectedItem === item,
      title: offsetWidth < scrollWidth && title || undefined,
      ref: {
        menuItemOptionRef: menuItemOptionRefs.current[index]
      }
    }, itemProps), itemToElement ? /*#__PURE__*/_react.default.createElement(ItemToElement, (0, _extends2.default)({
      key: itemProps.id
    }, item)) : itemToString(item), selectedItem === item && /*#__PURE__*/_react.default.createElement(_iconsReact.Checkmark16, {
      className: "".concat(prefix, "--list-box__menu-item__selected-icon")
    }));
  }))), !inline && !invalid && !warn && helper);
});

Dropdown.displayName = 'Dropdown';
Dropdown.propTypes = {
  /**
   * 'aria-label' of the ListBox component.
   */
  ariaLabel: _propTypes.default.string,

  /**
   * Provide a custom className to be applied on the bx--dropdown node
   */
  className: _propTypes.default.string,

  /**
   * Specify the direction of the dropdown. Can be either top or bottom.
   */
  direction: _propTypes.default.oneOf(['top', 'bottom']),

  /**
   * Disable the control
   */
  disabled: _propTypes.default.bool,

  /**
   * Additional props passed to Downshift
   */
  downshiftProps: _propTypes.default.object,

  /**
   * Provide helper text that is used alongside the control label for
   * additional help
   */
  helperText: _propTypes.default.node,

  /**
   * Specify whether the title text should be hidden or not
   */
  hideLabel: _propTypes.default.bool,

  /**
   * Specify a custom `id`
   */
  id: _propTypes.default.string.isRequired,

  /**
   * Allow users to pass in an arbitrary item or a string (in case their items are an array of strings)
   * from their collection that are pre-selected
   */
  initialSelectedItem: _propTypes.default.oneOfType([_propTypes.default.object, _propTypes.default.string, _propTypes.default.number]),

  /**
   * Specify whether you want the inline version of this control
   */
  inline: (0, _deprecate.default)(_propTypes.default.bool, "The `inline` prop has been deprecated and will\n    be removed in the next major release. To specify the inline variant of Dropdown, please use the `type` prop."),

  /**
   * Specify if the currently selected value is invalid.
   */
  invalid: _propTypes.default.bool,

  /**
   * Message which is displayed if the value is invalid.
   */
  invalidText: _propTypes.default.node,

  /**
   * Function to render items as custom components instead of strings.
   * Defaults to null and is overridden by a getter
   */
  itemToElement: _propTypes.default.func,

  /**
   * Helper function passed to downshift that allows the library to render a
   * given item to a string label. By default, it extracts the `label` field
   * from a given item to serve as the item label in the list.
   */
  itemToString: _propTypes.default.func,

  /**
   * We try to stay as generic as possible here to allow individuals to pass
   * in a collection of whatever kind of data structure they prefer
   */
  items: _propTypes.default.array.isRequired,

  /**
   * Generic `label` that will be used as the textual representation of what
   * this field is for
   */
  label: _propTypes.default.node.isRequired,

  /**
   * `true` to use the light version.
   */
  light: _propTypes.default.bool,

  /**
   * `onChange` is a utility for this controlled component to communicate to a
   * consuming component what kind of internal state changes are occurring.
   */
  onChange: _propTypes.default.func,

  /**
   * An optional callback to render the currently selected item as a react element instead of only
   * as a string.
   */
  renderSelectedItem: _propTypes.default.func,

  /**
   * In the case you want to control the dropdown selection entirely.
   */
  selectedItem: _propTypes.default.oneOfType([_propTypes.default.object, _propTypes.default.string, _propTypes.default.number]),

  /**
   * Specify the size of the ListBox. Currently supports either `sm`, `md` or `lg` as an option.
   */
  size: _ListBox.PropTypes.ListBoxSize,

  /**
   * Provide the title text that will be read by a screen reader when
   * visiting this control
   */
  titleText: _propTypes.default.node,

  /**
   * Callback function for translating ListBoxMenuIcon SVG title
   */
  translateWithId: _propTypes.default.func,

  /**
   * The dropdown type, `default` or `inline`
   */
  type: _ListBox.PropTypes.ListBoxType,

  /**
   * Specify whether the control is currently in warning state
   */
  warn: _propTypes.default.bool,

  /**
   * Provide the text that is displayed when the control is in warning state
   */
  warnText: _propTypes.default.node
};
Dropdown.defaultProps = {
  disabled: false,
  type: 'default',
  itemToString: defaultItemToString,
  itemToElement: null,
  light: false,
  titleText: '',
  helperText: '',
  direction: 'bottom'
};
var _default = Dropdown;
exports.default = _default;