"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

var _typeof = require("@babel/runtime/helpers/typeof");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _assertThisInitialized2 = _interopRequireDefault(require("@babel/runtime/helpers/assertThisInitialized"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _classnames = _interopRequireDefault(require("classnames"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var FeatureFlags = _interopRequireWildcard(require("@carbon/feature-flags"));

var _react = _interopRequireDefault(require("react"));

var _Filename = _interopRequireDefault(require("./Filename"));

var _FileUploaderButton = _interopRequireDefault(require("./FileUploaderButton"));

var _types = require("../../prop-types/types");

var _keyboard = require("../../internal/keyboard");

var _usePrefix = require("../../internal/usePrefix");

var _excluded = ["iconDescription", "buttonLabel", "buttonKind", "filenameStatus", "labelDescription", "labelTitle", "className", "multiple", "accept", "name", "size", "onDelete"];

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

var FileUploader = /*#__PURE__*/function (_React$Component) {
  (0, _inherits2.default)(FileUploader, _React$Component);

  var _super = _createSuper(FileUploader);

  function FileUploader() {
    var _this;

    (0, _classCallCheck2.default)(this, FileUploader);

    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    _this = _super.call.apply(_super, [this].concat(args));
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "state", {
      filenames: []
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "nodes", []);
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "handleChange", function (evt) {
      evt.stopPropagation();
      var filenames = Array.prototype.map.call(evt.target.files, function (file) {
        return file.name;
      });

      _this.setState({
        filenames: _this.props.multiple ? _this.state.filenames.concat(filenames) : filenames
      });

      if (_this.props.onChange) {
        _this.props.onChange(evt);
      }
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "handleClick", function (evt, _ref) {
      var index = _ref.index,
          filenameStatus = _ref.filenameStatus;

      if (filenameStatus === 'edit') {
        evt.stopPropagation();

        var filteredArray = _this.state.filenames.filter(function (filename) {
          return filename !== _this.nodes[index].innerText.trim();
        });

        _this.setState({
          filenames: filteredArray
        });

        if (_this.props.onDelete) {
          _this.props.onDelete(evt);
        }

        _this.props.onClick(evt);
      }
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "clearFiles", function () {
      // A clearFiles function that resets filenames and can be referenced using a ref by the parent.
      _this.setState({
        filenames: []
      });
    });
    return _this;
  }

  (0, _createClass2.default)(FileUploader, [{
    key: "render",
    value: function render() {
      var _classNames,
          _classNames2,
          _this2 = this;

      var _this$props = this.props,
          iconDescription = _this$props.iconDescription,
          buttonLabel = _this$props.buttonLabel,
          buttonKind = _this$props.buttonKind,
          filenameStatus = _this$props.filenameStatus,
          labelDescription = _this$props.labelDescription,
          labelTitle = _this$props.labelTitle,
          className = _this$props.className,
          multiple = _this$props.multiple,
          accept = _this$props.accept,
          name = _this$props.name,
          size = _this$props.size,
          onDelete = _this$props.onDelete,
          other = (0, _objectWithoutProperties2.default)(_this$props, _excluded);
      var prefix = this.context;
      var classes = (0, _classnames.default)((_classNames = {}, (0, _defineProperty2.default)(_classNames, "".concat(prefix, "--form-item"), true), (0, _defineProperty2.default)(_classNames, className, className), _classNames));
      var selectedFileClasses = (0, _classnames.default)("".concat(prefix, "--file__selected-file"), (_classNames2 = {}, (0, _defineProperty2.default)(_classNames2, "".concat(prefix, "--file__selected-file--md"), size === 'field' || size === 'md'), (0, _defineProperty2.default)(_classNames2, "".concat(prefix, "--file__selected-file--sm"), size === 'small' || size === 'sm'), _classNames2));
      return /*#__PURE__*/_react.default.createElement("div", (0, _extends2.default)({
        className: classes
      }, other), FeatureFlags.enabled('enable-v11-release') && !labelTitle ? null : /*#__PURE__*/_react.default.createElement("p", {
        className: "".concat(prefix, "--file--label")
      }, labelTitle), /*#__PURE__*/_react.default.createElement("p", {
        className: "".concat(prefix, "--label-description")
      }, labelDescription), /*#__PURE__*/_react.default.createElement(_FileUploaderButton.default, {
        labelText: buttonLabel,
        multiple: multiple,
        buttonKind: buttonKind,
        onChange: this.handleChange,
        disableLabelChanges: true,
        accept: accept,
        name: name,
        size: size
      }), /*#__PURE__*/_react.default.createElement("div", {
        className: "".concat(prefix, "--file-container")
      }, this.state.filenames.length === 0 ? null : this.state.filenames.map(function (name, index) {
        return /*#__PURE__*/_react.default.createElement("span", (0, _extends2.default)({
          key: index,
          className: selectedFileClasses,
          ref: function ref(node) {
            return _this2.nodes[index] = node;
          } // eslint-disable-line

        }, other), /*#__PURE__*/_react.default.createElement("p", {
          className: "".concat(prefix, "--file-filename")
        }, name), /*#__PURE__*/_react.default.createElement("span", {
          className: "".concat(prefix, "--file__state-container")
        }, /*#__PURE__*/_react.default.createElement(_Filename.default, {
          iconDescription: iconDescription,
          status: filenameStatus,
          onKeyDown: function onKeyDown(evt) {
            if ((0, _keyboard.matches)(evt, [_keyboard.keys.Enter, _keyboard.keys.Space])) {
              _this2.handleClick(evt, {
                index: index,
                filenameStatus: filenameStatus
              });
            }
          },
          onClick: function onClick(evt) {
            return _this2.handleClick(evt, {
              index: index,
              filenameStatus: filenameStatus
            });
          }
        })));
      })));
    }
  }], [{
    key: "getDerivedStateFromProps",
    value: function getDerivedStateFromProps(_ref2, state) {
      var filenameStatus = _ref2.filenameStatus;
      var prevFilenameStatus = state.prevFilenameStatus;
      return prevFilenameStatus === filenameStatus ? null : {
        filenameStatus: filenameStatus,
        prevFilenameStatus: filenameStatus
      };
    }
  }]);
  return FileUploader;
}(_react.default.Component);

exports.default = FileUploader;
(0, _defineProperty2.default)(FileUploader, "propTypes", {
  /**
   * Specify the types of files that this input should be able to receive
   */
  accept: _propTypes.default.arrayOf(_propTypes.default.string),

  /**
   * Specify the type of the <FileUploaderButton>
   */
  buttonKind: _propTypes.default.oneOf(_types.ButtonKinds),

  /**
   * Provide the label text to be read by screen readers when interacting with
   * the <FileUploaderButton>
   */
  buttonLabel: _propTypes.default.string,

  /**
   * Provide a custom className to be applied to the container node
   */
  className: _propTypes.default.string,

  /**
   * Specify the status of the File Upload
   */
  filenameStatus: _propTypes.default.oneOf(['edit', 'complete', 'uploading']).isRequired,

  /**
   * Provide a description for the complete/close icon that can be read by screen readers
   */
  iconDescription: FeatureFlags.enabled('enable-v11-release') ? _propTypes.default.string.isRequired : _propTypes.default.string,

  /**
   * Specify the description text of this <FileUploader>
   */
  labelDescription: _propTypes.default.string,

  /**
   * Specify the title text of this <FileUploader>
   */
  labelTitle: _propTypes.default.string,

  /**
   * Specify if the component should accept multiple files to upload
   */
  multiple: _propTypes.default.bool,

  /**
   * Provide a name for the underlying `<input>` node
   */
  name: _propTypes.default.string,

  /**
   * Provide an optional `onChange` hook that is called each time the input is
   * changed
   */
  onChange: _propTypes.default.func,

  /**
   * Provide an optional `onClick` hook that is called each time the
   * FileUploader is clicked
   */
  onClick: _propTypes.default.func,

  /**
   * Provide an optional `onDelete` hook that is called when an uploaded item
   * is removed
   */
  onDelete: _propTypes.default.func,

  /**
   * Specify the size of the FileUploaderButton, from a list of available
   * sizes. For `default` buttons, this prop can remain unspecified.
   * V11: `default`, `field`, and `small` will be removed
   */
  size: _propTypes.default.oneOf(['default', 'field', 'small', 'sm', 'md', 'lg'])
});
(0, _defineProperty2.default)(FileUploader, "contextType", _usePrefix.PrefixContext);
(0, _defineProperty2.default)(FileUploader, "defaultProps", {
  iconDescription: FeatureFlags.enabled('enable-v11-release') ? undefined : 'Provide icon description',
  filenameStatus: 'uploading',
  buttonLabel: '',
  buttonKind: 'primary',
  multiple: false,
  onClick: function onClick() {},
  accept: []
});