"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _react = _interopRequireDefault(require("react"));

var _classnames = _interopRequireDefault(require("classnames"));

var _carbonComponents = require("carbon-components");

var _Form = _interopRequireDefault(require("../Form"));

var _FormContext = require("./FormContext");

var _excluded = ["className", "children"];
var prefix = _carbonComponents.settings.prefix;

function FluidForm(_ref) {
  var className = _ref.className,
      children = _ref.children,
      other = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var classNames = (0, _classnames.default)("".concat(prefix, "--form--fluid"), className);
  return /*#__PURE__*/_react.default.createElement(_FormContext.FormContext.Provider, {
    value: {
      isFluid: true
    }
  }, /*#__PURE__*/_react.default.createElement(_Form.default, (0, _extends2.default)({
    className: classNames
  }, other), children));
}

FluidForm.propTypes = {
  /**
   * Provide children to be rendered inside of the <form> element
   */
  children: _propTypes.default.node,

  /**
   * Provide a custom className to be applied on the containing <form> node
   */
  className: _propTypes.default.string
};
var _default = FluidForm;
exports.default = _default;