"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

var _react = _interopRequireDefault(require("react"));

var _enzyme = require("enzyme");

var _ModalWrapper = _interopRequireDefault(require("../ModalWrapper"));

var _carbonComponents = require("carbon-components");

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
var prefix = _carbonComponents.settings.prefix;
describe('ModalWrapper', function () {
  var mockProps = {};
  beforeEach(function () {
    mockProps = {
      id: 'modal',
      buttonTriggerText: 'Test Modal',
      buttonTriggerClassName: 'btn-trigger',
      modalHeading: 'Transactional Modal',
      modalLabel: 'Test Modal Label',
      primaryButtonText: 'Save',
      secondaryButtonText: 'Cancel',
      handleSubmit: jest.fn(function () {
        return true;
      }),
      shouldCloseAfterSubmit: true,
      'aria-label': 'test modal'
    };
  });
  it('should render', function () {
    var wrapper = (0, _enzyme.mount)( /*#__PURE__*/_react.default.createElement(_ModalWrapper.default, mockProps, /*#__PURE__*/_react.default.createElement("p", {
      className: "".concat(prefix, "--modal-content__text")
    }, "Text")));
    expect(wrapper).toMatchSnapshot();
  });
  it('should close after a successful submit action', function () {
    var wrapper = (0, _enzyme.mount)( /*#__PURE__*/_react.default.createElement(_ModalWrapper.default, mockProps, /*#__PURE__*/_react.default.createElement("p", {
      className: "".concat(prefix, "--modal-content__text")
    }, "Text")));
    wrapper.find({
      children: mockProps.buttonTriggerText
    }).simulate('click');
    expect(wrapper.state('isOpen')).toBe(true);
    wrapper.find({
      children: mockProps.primaryButtonText
    }).simulate('click');
    expect(wrapper.state('isOpen')).toBe(false);
  });
  it('should return focus to the trigger button after closing', function () {
    var wrapper = (0, _enzyme.mount)( /*#__PURE__*/_react.default.createElement(_ModalWrapper.default, mockProps, /*#__PURE__*/_react.default.createElement("p", {
      className: "".concat(prefix, "--modal-content__text")
    }, "Text")));

    var _wrapper$instance = wrapper.instance(),
        triggerButton = _wrapper$instance.triggerButton;

    jest.spyOn(triggerButton.current, 'focus');
    wrapper.find({
      children: mockProps.buttonTriggerText
    }).simulate('click');
    wrapper.find({
      children: mockProps.primaryButtonText
    }).simulate('click');
    expect(triggerButton.current.focus).toHaveBeenCalledTimes(1);
  });
  it('should not close after an unsuccessful submit action', function () {
    mockProps.handleSubmit = jest.fn(function () {
      return false;
    });
    var wrapper = (0, _enzyme.mount)( /*#__PURE__*/_react.default.createElement(_ModalWrapper.default, mockProps, /*#__PURE__*/_react.default.createElement("p", {
      className: "".concat(prefix, "--modal-content__text")
    }, "Text")));
    wrapper.find({
      children: mockProps.buttonTriggerText
    }).simulate('click');
    expect(wrapper.state('isOpen')).toBe(true);
    wrapper.find({
      children: mockProps.primaryButtonText
    }).simulate('click');
    expect(wrapper.state('isOpen')).toBe(true);
  });
  it('should default to primary button', function () {
    var wrapper = (0, _enzyme.mount)( /*#__PURE__*/_react.default.createElement(_ModalWrapper.default, {
      "aria-label": "test"
    }));
    expect(wrapper.find(".".concat(prefix, "--btn--primary")).length).toEqual(2);
  });
  it('should render ghost button when ghost is passed', function () {
    var wrapper = (0, _enzyme.mount)( /*#__PURE__*/_react.default.createElement(_ModalWrapper.default, {
      "aria-label": "test"
    }));
    wrapper.setProps({
      triggerButtonKind: 'ghost'
    });
    expect(wrapper.find(".".concat(prefix, "--btn--ghost")).length).toEqual(1);
  });
  it('should render danger button when danger is passed', function () {
    var wrapper = (0, _enzyme.mount)( /*#__PURE__*/_react.default.createElement(_ModalWrapper.default, {
      "aria-label": "test"
    }));
    wrapper.setProps({
      triggerButtonKind: 'danger'
    });
    expect(wrapper.find(".".concat(prefix, "--btn--danger")).length).toEqual(1);
  });
  it('should render secondary button when secondary is passed', function () {
    var wrapper = (0, _enzyme.mount)( /*#__PURE__*/_react.default.createElement(_ModalWrapper.default, {
      "aria-label": "test"
    }));
    wrapper.setProps({
      triggerButtonKind: 'secondary'
    });
    expect(wrapper.find(".".concat(prefix, "--btn--secondary")).length).toEqual(2);
  });
});