"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

var _typeof = require("@babel/runtime/helpers/typeof");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _react = _interopRequireWildcard(require("react"));

var _classnames = _interopRequireDefault(require("classnames"));

var _Text = require("../../Text");

var _usePrefix = require("../../../internal/usePrefix");

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

var RadioButtonGroup = /*#__PURE__*/_react.default.forwardRef(function RadioButtonGroup(_ref, ref) {
  var _classNames;

  var children = _ref.children,
      className = _ref.className,
      defaultSelected = _ref.defaultSelected,
      disabled = _ref.disabled,
      _ref$labelPosition = _ref.labelPosition,
      labelPosition = _ref$labelPosition === void 0 ? 'right' : _ref$labelPosition,
      legendText = _ref.legendText,
      name = _ref.name,
      _ref$onChange = _ref.onChange,
      onChange = _ref$onChange === void 0 ? function () {} : _ref$onChange,
      _ref$orientation = _ref.orientation,
      orientation = _ref$orientation === void 0 ? 'horizontal' : _ref$orientation,
      valueSelected = _ref.valueSelected;
  var prefix = (0, _usePrefix.usePrefix)();

  var _useState = (0, _react.useState)(valueSelected !== 'undefined' ? valueSelected : defaultSelected),
      _useState2 = (0, _slicedToArray2.default)(_useState, 2),
      selected = _useState2[0],
      setSelected = _useState2[1];

  var _useState3 = (0, _react.useState)(selected),
      _useState4 = (0, _slicedToArray2.default)(_useState3, 2),
      prevValueSelected = _useState4[0],
      setPrevValueSelected = _useState4[1];
  /**
   * prop + state alignment - getDerivedStateFromProps
   * only update if selected prop changes
   */


  if (prevValueSelected !== valueSelected) {
    setSelected(valueSelected !== 'undefined' ? valueSelected : defaultSelected);
    setPrevValueSelected(valueSelected);
  }

  function getRadioButtons() {
    var mappedChildren = _react.default.Children.map(children, function (radioButton) {
      var value = radioButton.props.value;
      return /*#__PURE__*/_react.default.cloneElement(radioButton, {
        name: name,
        key: value,
        value: value,
        onChange: handleOnChange,
        checked: value === selected
      });
    });

    return mappedChildren;
  }

  function handleOnChange(newSelection, value, evt) {
    if (newSelection !== selected) {
      setSelected(newSelection);
      onChange(newSelection, name, evt);
    }
  }

  var fieldsetClasses = (0, _classnames.default)("".concat(prefix, "--radio-button-group"), (_classNames = {}, (0, _defineProperty2.default)(_classNames, "".concat(prefix, "--radio-button-group--").concat(orientation), orientation === 'vertical'), (0, _defineProperty2.default)(_classNames, "".concat(prefix, "--radio-button-group--label-").concat(labelPosition), labelPosition), _classNames));
  var wrapperClasses = (0, _classnames.default)("".concat(prefix, "--form-item"), className);
  return /*#__PURE__*/_react.default.createElement("div", {
    className: wrapperClasses,
    ref: ref
  }, /*#__PURE__*/_react.default.createElement("fieldset", {
    className: fieldsetClasses,
    disabled: disabled
  }, legendText && /*#__PURE__*/_react.default.createElement(_Text.Legend, {
    className: "".concat(prefix, "--label")
  }, legendText), getRadioButtons()));
});

RadioButtonGroup.propTypes = {
  /**
   * Provide a collection of <RadioButton> components to render in the group
   */
  children: _propTypes.default.node,

  /**
   * Provide an optional className to be applied to the container node
   */
  className: _propTypes.default.string,

  /**
   * Specify the <RadioButton> to be selected by default
   */
  defaultSelected: _propTypes.default.oneOfType([_propTypes.default.string, _propTypes.default.number]),

  /**
   * Specify whether the group is disabled
   */
  disabled: _propTypes.default.bool,

  /**
   * Provide where label text should be placed
   */
  labelPosition: _propTypes.default.oneOf(['left', 'right']),

  /**
   * Provide a legend to the RadioButtonGroup input that you are
   * exposing to the user
   */
  legendText: _propTypes.default.node,

  /**
   * Specify the name of the underlying `<input>` nodes
   */
  name: _propTypes.default.string.isRequired,

  /**
   * Provide an optional `onChange` hook that is called whenever the value of
   * the group changes
   */
  onChange: _propTypes.default.func,

  /**
   * Provide where radio buttons should be placed
   */
  orientation: _propTypes.default.oneOf(['horizontal', 'vertical']),

  /**
   * Specify the value that is currently selected in the group
   */
  valueSelected: _propTypes.default.oneOfType([_propTypes.default.string, _propTypes.default.number])
};
var _default = RadioButtonGroup;
exports.default = _default;