"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Skeleton = exports.Container = exports.Playground = exports._Default = exports.default = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _react = _interopRequireDefault(require("react"));

var _addonActions = require("@storybook/addon-actions");

var _addonKnobs = require("@storybook/addon-knobs");

var _carbonComponents = require("carbon-components");

var _classnames = _interopRequireDefault(require("classnames"));

require("./Tabs-story.scss");

var _CodeSnippet = _interopRequireDefault(require("../CodeSnippet"));

var _Button = _interopRequireDefault(require("../Button"));

var _Tabs = _interopRequireDefault(require("./Tabs"));

var _Tab = _interopRequireDefault(require("../Tab"));

var _Tabs2 = _interopRequireDefault(require("../Tabs/Tabs.Skeleton"));

var _Tabs3 = _interopRequireDefault(require("./Tabs.mdx"));

var _excluded = ["selected", "children", "className"];
var selectionModes = {
  'Change selection automatically upon focus (automatic)': 'automatic',
  'Change selection on explicit gesture (manual)': 'manual'
};
var types = {
  Default: 'default',
  Container: 'container'
};
var prefix = _carbonComponents.settings.prefix;
var props = {
  tabs: function tabs() {
    return {
      type: (0, _addonKnobs.select)('Type of Tabs (type)', types, 'default'),
      className: 'some-class',
      light: (0, _addonKnobs.boolean)('Light variant (light)', false),
      selected: (0, _addonKnobs.number)('The index of the selected tab (selected in <Tabs>)', 1),
      onSelectionChange: (0, _addonActions.action)('onSelectionChange'),
      tabContentClassName: (0, _addonKnobs.text)('The className for the child `<TabContent>` components', 'tab-content'),
      scrollIntoView: (0, _addonKnobs.boolean)('Scroll to selected tab on component rerender (scrollIntoView)', true),
      selectionMode: (0, _addonKnobs.select)('Selection mode (selectionMode)', selectionModes, 'automatic')
    };
  },
  tab: function tab() {
    return {
      disabled: (0, _addonKnobs.boolean)('Disabled (disabled in <Tab>)', false),
      onClick: (0, _addonActions.action)('onClick'),
      onKeyDown: (0, _addonActions.action)('onKeyDown')
    };
  }
};

var CustomLabel = function CustomLabel(_ref) {
  var text = _ref.text;
  return text;
};

var CodeSnippetExample = function CodeSnippetExample() {
  return /*#__PURE__*/_react.default.createElement(_CodeSnippet.default, {
    type: "multi"
  }, "@mixin grid-container {\n  width: 100%;\n  padding-right: padding(mobile);\n  padding-left: padding(mobile);\n  @include breakpoint(bp--xs--major) {\n    padding-right: padding(xs);\n    padding-left: padding(xs);\n  }\n}\n$z-indexes: (\n  modal : 9000,\n  overlay : 8000,\n  dropdown : 7000,\n  header : 6000,\n  footer : 5000,\n  hidden : - 1,\n  overflowHidden: - 1,\n  floating: 10000\n);");
};

var TabContentRenderedOnlyWhenSelected = function TabContentRenderedOnlyWhenSelected(_ref2) {
  var selected = _ref2.selected,
      children = _ref2.children,
      className = _ref2.className,
      other = (0, _objectWithoutProperties2.default)(_ref2, _excluded);
  return !selected ? /*#__PURE__*/_react.default.createElement("div", (0, _extends2.default)({}, other, {
    className: "".concat(prefix, "--visually-hidden")
  })) : /*#__PURE__*/_react.default.createElement("div", (0, _extends2.default)({}, other, {
    className: (0, _classnames.default)(className, "".concat(prefix, "--tab-content")),
    role: "tabpanel",
    selected: selected
  }), children);
};

var _default = {
  title: 'Components/Tabs',
  decorators: [_addonKnobs.withKnobs],
  parameters: {
    component: _Tabs.default,
    docs: {
      page: _Tabs3.default
    },
    subcomponents: {
      Tab: _Tab.default,
      TabsSkeleton: _Tabs2.default
    }
  }
};
exports.default = _default;

var _Default = function _Default() {
  return /*#__PURE__*/_react.default.createElement(_Tabs.default, null, /*#__PURE__*/_react.default.createElement(_Tab.default, {
    id: "tab-1",
    label: "Tab label 1"
  }, /*#__PURE__*/_react.default.createElement("p", null, "Content for first tab goes here.")), /*#__PURE__*/_react.default.createElement(_Tab.default, {
    id: "tab-2",
    label: "Tab label 2"
  }, /*#__PURE__*/_react.default.createElement("p", null, "Content for second tab goes here."), /*#__PURE__*/_react.default.createElement(_Button.default, null, "With a button")), /*#__PURE__*/_react.default.createElement(_Tab.default, {
    id: "tab-3",
    label: "Tab label 3",
    disabled: true
  }, /*#__PURE__*/_react.default.createElement("p", null, "Content for third tab goes here.")), /*#__PURE__*/_react.default.createElement(_Tab.default, {
    id: "tab-4",
    label: "Tab label 4 shows truncation",
    title: "Tab label 4 shows truncation"
  }, /*#__PURE__*/_react.default.createElement("p", null, "Content for fourth tab goes here.")), /*#__PURE__*/_react.default.createElement(_Tab.default, {
    label: /*#__PURE__*/_react.default.createElement("div", null, "Custom Label")
  }, /*#__PURE__*/_react.default.createElement("p", null, "Content for fifth tab goes here.")));
};

exports._Default = _Default;
_Default.story = {
  name: 'Tabs'
};

var Playground = function Playground() {
  return /*#__PURE__*/_react.default.createElement("div", {
    className: props.tabs().light ? 'tabs-story-wrapper--light' : null
  }, /*#__PURE__*/_react.default.createElement(_Tabs.default, props.tabs(), /*#__PURE__*/_react.default.createElement(_Tab.default, (0, _extends2.default)({}, props.tab(), {
    id: "tab-1",
    label: "Tab label 1"
  }), /*#__PURE__*/_react.default.createElement("div", {
    className: "some-content"
  }, /*#__PURE__*/_react.default.createElement("p", null, "Content for first tab goes here."))), /*#__PURE__*/_react.default.createElement(_Tab.default, (0, _extends2.default)({}, props.tab(), {
    id: "tab-2",
    label: "Tab label 2"
  }), /*#__PURE__*/_react.default.createElement("div", {
    className: "some-content"
  }, /*#__PURE__*/_react.default.createElement("p", null, "Content for second tab goes here."))), /*#__PURE__*/_react.default.createElement(_Tab.default, (0, _extends2.default)({}, props.tab(), {
    id: "tab-3",
    label: "Tab label 3",
    disabled: true
  }), /*#__PURE__*/_react.default.createElement("div", {
    className: "some-content"
  }, /*#__PURE__*/_react.default.createElement("p", null, "Content for third tab goes here."))), /*#__PURE__*/_react.default.createElement(_Tab.default, (0, _extends2.default)({}, props.tab(), {
    id: "tab-4",
    label: "Tab label 4 shows truncation",
    title: "Tab label 4 shows truncation",
    renderContent: TabContentRenderedOnlyWhenSelected
  }), /*#__PURE__*/_react.default.createElement("div", {
    className: "some-content"
  }, /*#__PURE__*/_react.default.createElement("p", null, "Content for fourth tab goes here."), /*#__PURE__*/_react.default.createElement("p", null, "This example uses the\xA0", /*#__PURE__*/_react.default.createElement(_CodeSnippet.default, {
    type: "inline"
  }, "renderContent"), " prop to re-render content when the tab is selected."), /*#__PURE__*/_react.default.createElement(CodeSnippetExample, null))), /*#__PURE__*/_react.default.createElement(_Tab.default, (0, _extends2.default)({}, props.tab(), {
    label: /*#__PURE__*/_react.default.createElement(CustomLabel, {
      text: "Custom Label"
    })
  }), /*#__PURE__*/_react.default.createElement("div", {
    className: "some-content"
  }, /*#__PURE__*/_react.default.createElement("p", null, "Content for fifth tab goes here.")))));
};

exports.Playground = Playground;

var Container = function Container() {
  return /*#__PURE__*/_react.default.createElement(_Tabs.default, {
    type: "container"
  }, /*#__PURE__*/_react.default.createElement(_Tab.default, {
    id: "tab-1",
    label: "Tab label 1"
  }, /*#__PURE__*/_react.default.createElement("p", null, "Content for first tab goes here.")), /*#__PURE__*/_react.default.createElement(_Tab.default, {
    id: "tab-2",
    label: "Tab label 2"
  }, /*#__PURE__*/_react.default.createElement("p", null, "Content for second tab goes here.")), /*#__PURE__*/_react.default.createElement(_Tab.default, {
    id: "tab-3",
    label: "Tab label 3 shows truncation",
    title: "Tab label 3 shows truncation"
  }, /*#__PURE__*/_react.default.createElement("p", null, "Content for third tab goes here.")), /*#__PURE__*/_react.default.createElement(_Tab.default, {
    label: /*#__PURE__*/_react.default.createElement("div", null, "Custom Label")
  }, /*#__PURE__*/_react.default.createElement("p", null, "Content for fourth tab goes here.")));
};

exports.Container = Container;

var Skeleton = function Skeleton() {
  var isLoading = (0, _addonKnobs.boolean)('isLoading', true);
  return /*#__PURE__*/_react.default.createElement("div", {
    style: {
      maxWidth: '100%'
    }
  }, isLoading ? /*#__PURE__*/_react.default.createElement(_Tabs2.default, {
    type: (0, _addonKnobs.select)('Type of Tabs (type)', types, 'default')
  }) : /*#__PURE__*/_react.default.createElement(_Tabs.default, {
    type: (0, _addonKnobs.select)('Type of Tabs (type)', types, 'default')
  }, /*#__PURE__*/_react.default.createElement(_Tab.default, {
    id: "tab-1",
    label: "Tab label 1"
  }, /*#__PURE__*/_react.default.createElement("p", null, "Content for first tab goes here.")), /*#__PURE__*/_react.default.createElement(_Tab.default, {
    id: "tab-2",
    label: "Tab label 2"
  }, /*#__PURE__*/_react.default.createElement("p", null, "Content for second tab goes here.")), /*#__PURE__*/_react.default.createElement(_Tab.default, {
    id: "tab-3",
    label: "Tab label 3",
    disabled: true
  }, /*#__PURE__*/_react.default.createElement("p", null, "Content for third tab goes here.")), /*#__PURE__*/_react.default.createElement(_Tab.default, {
    id: "tab-4",
    label: "Tab label 4 shows truncation",
    title: "Tab label 4 shows truncation"
  }, /*#__PURE__*/_react.default.createElement("p", null, "Content for fourth tab goes here.")), /*#__PURE__*/_react.default.createElement(_Tab.default, {
    label: /*#__PURE__*/_react.default.createElement("div", null, "Custom Label")
  }, /*#__PURE__*/_react.default.createElement("p", null, "Content for fifth tab goes here."))));
};

exports.Skeleton = Skeleton;