"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _defineProperty4 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _react = _interopRequireDefault(require("react"));

var _classnames = _interopRequireDefault(require("classnames"));

var _setupGetInstanceId = _interopRequireDefault(require("../../tools/setupGetInstanceId"));

var _keyboard = require("../../internal/keyboard");

var _usePrefix = require("../../internal/usePrefix");

var _defineProperty2, _defineProperty3;

var _excluded = ["className", "defaultToggled", "toggled", "onChange", "onToggle", "id", "labelText", "labelA", "labelB", "size"];

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

var getInstanceId = (0, _setupGetInstanceId.default)();

var Toggle = /*#__PURE__*/function (_React$Component) {
  (0, _inherits2.default)(Toggle, _React$Component);

  var _super = _createSuper(Toggle);

  function Toggle() {
    (0, _classCallCheck2.default)(this, Toggle);
    return _super.apply(this, arguments);
  }

  (0, _createClass2.default)(Toggle, [{
    key: "render",
    value: function render() {
      var prefix = this.context;
      var _this$props = this.props,
          className = _this$props.className,
          defaultToggled = _this$props.defaultToggled,
          toggled = _this$props.toggled,
          _onChange = _this$props.onChange,
          onToggle = _this$props.onToggle,
          _this$props$id = _this$props.id,
          id = _this$props$id === void 0 ? this.inputId = this.inputId || "__carbon-toggle_".concat(getInstanceId()) : _this$props$id,
          labelText = _this$props.labelText,
          labelA = _this$props.labelA,
          labelB = _this$props.labelB,
          size = _this$props.size,
          other = (0, _objectWithoutProperties2.default)(_this$props, _excluded);
      var input;
      var wrapperClasses = (0, _classnames.default)("".concat(prefix, "--form-item"), (0, _defineProperty4.default)({}, className, className));
      var toggleClasses = (0, _classnames.default)("".concat(prefix, "--toggle-input"), (0, _defineProperty4.default)({}, "".concat(prefix, "--toggle-input--small"), size === 'sm'));
      var checkedProps = {};

      if (typeof toggled !== 'undefined') {
        checkedProps.checked = toggled;
      } else {
        checkedProps.defaultChecked = defaultToggled;
      }

      return /*#__PURE__*/_react.default.createElement("div", {
        className: wrapperClasses
      }, /*#__PURE__*/_react.default.createElement("input", (0, _extends2.default)({}, other, checkedProps, {
        "aria-label": null,
        type: "checkbox",
        id: id,
        className: toggleClasses,
        onChange: function onChange(evt) {
          _onChange && _onChange(evt);
          onToggle(input.checked, id, evt);
        },
        ref: function ref(el) {
          input = el;
        },
        onKeyUp: function onKeyUp(evt) {
          if ((0, _keyboard.match)(evt, _keyboard.keys.Enter)) {
            input.checked = !input.checked;
            _onChange && _onChange(evt);
            onToggle(input.checked, id, evt);
          }
        }
      })), /*#__PURE__*/_react.default.createElement("label", {
        className: "".concat(prefix, "--toggle-input__label"),
        htmlFor: id,
        "aria-label": typeof labelText === 'string' ? null : this.props['aria-label']
      }, labelText, /*#__PURE__*/_react.default.createElement("span", {
        className: "".concat(prefix, "--toggle__switch")
      }, size && /*#__PURE__*/_react.default.createElement("svg", {
        className: "".concat(prefix, "--toggle__check"),
        width: "6px",
        height: "5px",
        viewBox: "0 0 6 5"
      }, /*#__PURE__*/_react.default.createElement("path", {
        d: "M2.2 2.7L5 0 6 1 2.2 5 0 2.7 1 1.5z"
      })), /*#__PURE__*/_react.default.createElement("span", {
        className: "".concat(prefix, "--toggle__text--off"),
        "aria-hidden": "true"
      }, labelA), /*#__PURE__*/_react.default.createElement("span", {
        className: "".concat(prefix, "--toggle__text--on"),
        "aria-hidden": "true"
      }, labelB))));
    }
  }]);
  return Toggle;
}(_react.default.Component);

(0, _defineProperty4.default)(Toggle, "propTypes", (_defineProperty2 = {}, (0, _defineProperty4.default)(_defineProperty2, 'aria-label', _propTypes.default.string.isRequired), (0, _defineProperty4.default)(_defineProperty2, "className", _propTypes.default.string), (0, _defineProperty4.default)(_defineProperty2, "defaultToggled", _propTypes.default.bool), (0, _defineProperty4.default)(_defineProperty2, "id", _propTypes.default.string.isRequired), (0, _defineProperty4.default)(_defineProperty2, "labelA", _propTypes.default.node.isRequired), (0, _defineProperty4.default)(_defineProperty2, "labelB", _propTypes.default.node.isRequired), (0, _defineProperty4.default)(_defineProperty2, "labelText", _propTypes.default.node), (0, _defineProperty4.default)(_defineProperty2, "onChange", _propTypes.default.func), (0, _defineProperty4.default)(_defineProperty2, "onToggle", _propTypes.default.func), (0, _defineProperty4.default)(_defineProperty2, "size", _propTypes.default.oneOf(['sm', 'md'])), (0, _defineProperty4.default)(_defineProperty2, "toggled", _propTypes.default.bool), _defineProperty2));
(0, _defineProperty4.default)(Toggle, "contextType", _usePrefix.PrefixContext);
(0, _defineProperty4.default)(Toggle, "defaultProps", (_defineProperty3 = {
  defaultToggled: false
}, (0, _defineProperty4.default)(_defineProperty3, 'aria-label', 'Toggle'), (0, _defineProperty4.default)(_defineProperty3, "labelA", 'Off'), (0, _defineProperty4.default)(_defineProperty3, "labelB", 'On'), (0, _defineProperty4.default)(_defineProperty3, "onToggle", function onToggle() {}), _defineProperty3));
var _default = Toggle;
exports.default = _default;