"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

var _typeof = require("@babel/runtime/helpers/typeof");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _toConsumableArray2 = _interopRequireDefault(require("@babel/runtime/helpers/toConsumableArray"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _classnames = _interopRequireDefault(require("classnames"));

var _react = _interopRequireWildcard(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _setupGetInstanceId = _interopRequireDefault(require("../../tools/setupGetInstanceId"));

var _events = require("../../tools/events");

var _keyboard = require("../../internal/keyboard");

var _toggleClass = _interopRequireDefault(require("../../tools/toggleClass"));

var _usePrefix = require("../../internal/usePrefix");

var _excluded = ["id", "className", "children", "direction", "disabled", "align", "onClick", "onBlur", "onFocus", "onMouseEnter", "onMouseLeave", "renderIcon", "tooltipText"];

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

var getInstanceId = (0, _setupGetInstanceId.default)();

var TooltipIcon = function TooltipIcon(_ref) {
  var _cx;

  var id = _ref.id,
      className = _ref.className,
      children = _ref.children,
      direction = _ref.direction,
      disabled = _ref.disabled,
      align = _ref.align,
      onClick = _ref.onClick,
      onBlur = _ref.onBlur,
      onFocus = _ref.onFocus,
      onMouseEnter = _ref.onMouseEnter,
      onMouseLeave = _ref.onMouseLeave,
      IconElement = _ref.renderIcon,
      tooltipText = _ref.tooltipText,
      rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var prefix = (0, _usePrefix.usePrefix)();

  var _useState = (0, _react.useState)(true),
      _useState2 = (0, _slicedToArray2.default)(_useState, 2),
      allowTooltipVisibility = _useState2[0],
      setAllowTooltipVisibility = _useState2[1];

  var _useState3 = (0, _react.useState)(false),
      _useState4 = (0, _slicedToArray2.default)(_useState3, 2),
      isHovered = _useState4[0],
      setIsHovered = _useState4[1];

  var _useState5 = (0, _react.useState)(false),
      _useState6 = (0, _slicedToArray2.default)(_useState5, 2),
      isFocused = _useState6[0],
      setIsFocused = _useState6[1];

  var tooltipRef = (0, _react.useRef)(null);
  var tooltipTimeout = (0, _react.useRef)(null);
  var tooltipId = id || "icon-tooltip-".concat(getInstanceId());
  var tooltipTriggerClasses = (0, _classnames.default)("".concat(prefix, "--tooltip__trigger"), "".concat(prefix, "--tooltip--a11y"), className, (_cx = {}, (0, _defineProperty2.default)(_cx, "".concat(prefix, "--tooltip--").concat(direction), direction), (0, _defineProperty2.default)(_cx, "".concat(prefix, "--tooltip--align-").concat(align), align), (0, _defineProperty2.default)(_cx, "".concat(prefix, "--tooltip--hidden"), !allowTooltipVisibility || disabled), (0, _defineProperty2.default)(_cx, "".concat(prefix, "--tooltip--visible"), isHovered), _cx));

  var closeTooltips = function closeTooltips(evt) {
    var _document;

    var tooltipNode = (_document = document) === null || _document === void 0 ? void 0 : _document.querySelectorAll(".".concat(prefix, "--tooltip--a11y"));
    (0, _toConsumableArray2.default)(tooltipNode).map(function (node) {
      (0, _toggleClass.default)(node, "".concat(prefix, "--tooltip--hidden"), node !== evt.currentTarget);
    });
  };

  var handleFocus = function handleFocus(evt) {
    closeTooltips(evt);
    setIsFocused(true);
    setAllowTooltipVisibility(true);
  };

  var handleBlur = function handleBlur() {
    setIsHovered(false);
    setIsFocused(false);
    setAllowTooltipVisibility(false);
  };

  var handleMouseEnter = function handleMouseEnter(evt) {
    if (!disabled) {
      tooltipTimeout.current && clearTimeout(tooltipTimeout.current);

      if (evt.target === tooltipRef.current) {
        setAllowTooltipVisibility(true);
        return;
      }

      closeTooltips(evt);
      setAllowTooltipVisibility(true);
    }
  };

  var handleMouseLeave = function handleMouseLeave() {
    if (!isFocused) {
      tooltipTimeout.current = setTimeout(function () {
        setAllowTooltipVisibility(false);
        setIsHovered(false);
      }, 100);
    }
  };

  var handleClick = function handleClick(evt) {
    setAllowTooltipVisibility(false); // Prevent clicks on the tooltip from triggering the button click event

    if (evt.target === tooltipRef.current) {
      evt.preventDefault();
      return;
    }
  };

  (0, _react.useEffect)(function () {
    var handleEscKeyDown = function handleEscKeyDown(event) {
      if ((0, _keyboard.matches)(event, [_keyboard.keys.Escape])) {
        setAllowTooltipVisibility(false);
        setIsHovered(false);
      }
    };

    document.addEventListener('keydown', handleEscKeyDown);
    return function () {
      return document.removeEventListener('keydown', handleEscKeyDown);
    };
  }, []);
  var cursorStyle;

  if (disabled) {
    cursorStyle = 'not-allowed';
  } else {
    cursorStyle = onClick ? 'pointer' : 'default';
  }

  return /*#__PURE__*/_react.default.createElement("button", (0, _extends2.default)({
    disabled: disabled,
    style: {
      cursor: cursorStyle
    }
  }, rest, {
    type: "button",
    className: tooltipTriggerClasses,
    "aria-describedby": tooltipId,
    onMouseEnter: (0, _events.composeEventHandlers)([onMouseEnter, handleMouseEnter]),
    onMouseLeave: (0, _events.composeEventHandlers)([onMouseLeave, handleMouseLeave]),
    onFocus: (0, _events.composeEventHandlers)([onFocus, handleFocus]),
    onBlur: (0, _events.composeEventHandlers)([onBlur, handleBlur]),
    onClick: (0, _events.composeEventHandlers)([handleClick, onClick])
  }), /*#__PURE__*/_react.default.createElement("span", {
    ref: tooltipRef,
    onMouseEnter: handleMouseEnter,
    className: "".concat(prefix, "--assistive-text"),
    id: tooltipId
  }, tooltipText), IconElement && /*#__PURE__*/_react.default.createElement(IconElement, null), !IconElement && children);
};

TooltipIcon.propTypes = {
  /**
   * Specify the alignment (to the trigger button) of the tooltip.
   * Can be one of: start, center, or end.
   */
  align: _propTypes.default.oneOf(['start', 'center', 'end']),

  /**
   * Specify an icon as children that will be used as the tooltip trigger. This
   * can be an icon from our Icon component, or a custom SVG element.
   */
  children: _propTypes.default.node,

  /**
   * Specify an optional className to be applied to the trigger node
   */
  className: _propTypes.default.string,

  /**
   * Specify the direction of the tooltip. Can be either top or bottom.
   */
  direction: _propTypes.default.oneOf(['top', 'right', 'left', 'bottom']),

  /**
   * Specify whether the `<TooltipIcon>` should be disabled
   */
  disabled: _propTypes.default.bool,

  /**
   * Optionally specify a custom id for the tooltip. If one is not provided, we
   * generate a unique id for you.
   */
  id: _propTypes.default.string,

  /**
   * The event handler for the `blur` event.
   */
  onBlur: _propTypes.default.func,

  /**
   * The event handler for the `click` event.
   */
  onClick: _propTypes.default.func,

  /**
   * The event handler for the `focus` event.
   */
  onFocus: _propTypes.default.func,

  /**
   * The event handler for the `mouseenter` event.
   */
  onMouseEnter: _propTypes.default.func,

  /**
   * The event handler for the `mouseleave` event.
   */
  onMouseLeave: _propTypes.default.func,

  /**
   * Function called to override icon rendering.
   */
  renderIcon: _propTypes.default.oneOfType([_propTypes.default.func, _propTypes.default.object]),

  /**
   * Provide the ARIA label for the tooltip.
   * TODO: rename this prop (will be a breaking change)
   */
  tooltipText: _propTypes.default.node.isRequired
};
TooltipIcon.defaultProps = {
  direction: 'bottom',
  align: 'center'
};
var _default = TooltipIcon;
exports.default = _default;