"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _classnames = _interopRequireDefault(require("classnames"));

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _usePrefix = require("../../internal/usePrefix");

var _excluded = ["children", "className", "href", "tabIndex"];

var SkipToContent = function SkipToContent(_ref) {
  var children = _ref.children,
      customClassName = _ref.className,
      href = _ref.href,
      tabIndex = _ref.tabIndex,
      rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var prefix = (0, _usePrefix.usePrefix)();
  var className = (0, _classnames.default)("".concat(prefix, "--skip-to-content"), customClassName);
  return /*#__PURE__*/_react.default.createElement("a", (0, _extends2.default)({}, rest, {
    className: className,
    href: href,
    tabIndex: tabIndex
  }), children);
};

SkipToContent.propTypes = {
  /**
   * Provide text to display in the SkipToContent `a` tag
   */
  children: _propTypes.default.string.isRequired,
  className: _propTypes.default.string,

  /**
   * Provide the `href` to the id of the element on your package that is the
   * main content.
   */
  href: _propTypes.default.string.isRequired,

  /**
   * Optionally override the default tabindex of 0
   */
  tabIndex: _propTypes.default.string
};
SkipToContent.defaultProps = {
  children: 'Skip to main content',
  href: '#main-content',
  tabIndex: '0'
};
var _default = SkipToContent;
exports.default = _default;