"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.summaryTab = exports.buildSummary = void 0;

var _lodash = _interopRequireDefault(require("lodash"));

var _react = _interopRequireDefault(require("react"));

var _reactDom = _interopRequireDefault(require("react-dom"));

var _carbonComponentsReact = require("carbon-components-react");

var _i18n = _interopRequireDefault(require("../../util/i18n"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

const buildSummary = items => {
  const node = document.createElement('div');
  node.classList.add('scrollable');
  node.classList.add('bx--structured-list--summary');
  const rows = Object.entries(items).filter(key => !key[0][0].match('_'));

  const summary = () => {
    return /*#__PURE__*/_react.default.createElement(_carbonComponentsReact.StructuredListWrapper, null, /*#__PURE__*/_react.default.createElement(_carbonComponentsReact.StructuredListBody, null, rows.map(row => /*#__PURE__*/_react.default.createElement(_carbonComponentsReact.StructuredListRow, {
      key: _lodash.default.get(row, '[0]', '')
    }, /*#__PURE__*/_react.default.createElement(_carbonComponentsReact.StructuredListCell, null, /*#__PURE__*/_react.default.createElement("span", {
      className: "bx--structured-list-td-header"
    }, `${row[0]}`), /*#__PURE__*/_react.default.createElement("br", null), /*#__PURE__*/_react.default.createElement("span", {
      className: "bx--structured-list-td-body"
    }, `${row[1]}`))))));
  };

  _reactDom.default.render( /*#__PURE__*/_react.default.createElement(summary), node);

  return node;
};

exports.buildSummary = buildSummary;

const summaryTab = items => {
  return {
    mode: 'summaryTab',
    defaultMode: true,
    label: (0, _i18n.default)('search.label.summary'),
    order: 1,
    content: buildSummary(items)
  };
};

exports.summaryTab = summaryTab;