import _extends from "@babel/runtime/helpers/extends";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["aria-current", "children", "className", "href", "isCurrentPage"];

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import PropTypes from 'prop-types';
import React from 'react';
import cx from 'classnames';
import { settings } from 'carbon-components';
import Link from '../Link';
import { OverflowMenuHorizontal16 } from '@carbon/icons-react';
var prefix = settings.prefix;
var BreadcrumbItem = /*#__PURE__*/React.forwardRef(function BreadcrumbItem(_ref, ref) {
  var _cx;

  var ariaCurrent = _ref['aria-current'],
      children = _ref.children,
      customClassName = _ref.className,
      href = _ref.href,
      isCurrentPage = _ref.isCurrentPage,
      rest = _objectWithoutProperties(_ref, _excluded);

  var className = cx((_cx = {}, _defineProperty(_cx, "".concat(prefix, "--breadcrumb-item"), true), _defineProperty(_cx, "".concat(prefix, "--breadcrumb-item--current"), isCurrentPage && ariaCurrent !== 'page'), _defineProperty(_cx, customClassName, !!customClassName), _cx));

  if (children.type && children.type.displayName !== undefined && children.type.displayName.includes('OverflowMenu')) {
    var horizontalOverflowIcon = /*#__PURE__*/React.createElement(OverflowMenuHorizontal16, {
      className: "".concat(prefix, "--overflow-menu__icon")
    });
    return /*#__PURE__*/React.createElement("li", _extends({
      className: className
    }, rest), /*#__PURE__*/React.cloneElement(children, {
      menuOptionsClass: "".concat(prefix, "--breadcrumb-menu-options"),
      menuOffset: {
        top: 10,
        left: 59
      },
      renderIcon: function renderIcon() {
        return horizontalOverflowIcon;
      }
    }));
  }

  if (typeof children === 'string') {
    return /*#__PURE__*/React.createElement("li", _extends({
      className: className,
      ref: ref
    }, rest), href ? /*#__PURE__*/React.createElement(Link, {
      href: href,
      "aria-current": ariaCurrent
    }, children) : /*#__PURE__*/React.createElement("span", {
      className: "".concat(prefix, "--link")
    }, children));
  }

  return /*#__PURE__*/React.createElement("li", _extends({
    className: className,
    ref: ref
  }, rest), /*#__PURE__*/React.cloneElement(children, {
    'aria-current': ariaCurrent,
    className: cx("".concat(prefix, "--link"), children.props.className)
  }));
});
BreadcrumbItem.displayName = 'BreadcrumbItem';
BreadcrumbItem.propTypes = {
  'aria-current': PropTypes.oneOfType([PropTypes.string, PropTypes.bool]),

  /**
   * Pass in content that will be inside of the BreadcrumbItem
   */
  children: PropTypes.node,

  /**
   * Specify an optional className to be applied to the container node
   */
  className: PropTypes.string,

  /**
   * Optional string representing the link location for the BreadcrumbItem
   */
  href: PropTypes.string,

  /**
   * Provide if this breadcrumb item represents the current page
   */
  isCurrentPage: PropTypes.bool
};
export default BreadcrumbItem;