/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import 'carbon-components/scss/components/button/_button.scss';
import React from 'react';
import { mount } from '@cypress/react';
import { default as Button } from './Button';
import { Add16 } from '@carbon/icons-react';
describe('Button', function () {
  beforeEach(function () {
    mount( /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(Button, null, "button"), /*#__PURE__*/React.createElement(Button, {
      size: "sm"
    }, "size-sm"), /*#__PURE__*/React.createElement(Button, {
      size: "md"
    }, "size-md"), /*#__PURE__*/React.createElement(Button, {
      size: "lg"
    }, "size-lg"), /*#__PURE__*/React.createElement(Button, {
      size: "xl"
    }, "size-xl"), /*#__PURE__*/React.createElement(Button, {
      size: "sm",
      expressive: true
    }, "expressive size-sm"), /*#__PURE__*/React.createElement(Button, {
      size: "md",
      expressive: true
    }, "expressive size-md"), /*#__PURE__*/React.createElement(Button, {
      size: "lg",
      expressive: true
    }, "expressive size-lg"), /*#__PURE__*/React.createElement(Button, {
      size: "xl",
      expressive: true
    }, "expressive size-xl"), /*#__PURE__*/React.createElement(Button, {
      kind: "secondary"
    }, "secondary"), /*#__PURE__*/React.createElement(Button, {
      kind: "tertiary"
    }, "tertiary"), /*#__PURE__*/React.createElement(Button, {
      kind: "ghost"
    }, "ghost"), /*#__PURE__*/React.createElement(Button, {
      kind: "danger",
      dangerDescription: "sample"
    }, "danger"), /*#__PURE__*/React.createElement(Button, {
      kind: "danger--tertiary",
      dangerDescription: "sample"
    }, "danger--tertiary"), /*#__PURE__*/React.createElement(Button, {
      kind: "danger--ghost",
      dangerDescription: "sample"
    }, "danger--ghost"), /*#__PURE__*/React.createElement(Button, {
      hasIconOnly: true,
      renderIcon: Add16,
      "data-testid": "icon-only"
    })));
  });
  it('should render', function () {
    // full string match regex syntax ^string$ to prevent collisions
    cy.findByText(/^button$/).should('be.visible');
    cy.findByText(/^size-sm$/).should('be.visible');
    cy.findByText(/^size-md$/).should('be.visible');
    cy.findByText(/^size-lg$/).should('be.visible');
    cy.findByText(/^size-xl$/).should('be.visible');
    cy.findByText(/^expressive size-sm$/).should('be.visible');
    cy.findByText(/^expressive size-md$/).should('be.visible');
    cy.findByText(/^expressive size-lg$/).should('be.visible');
    cy.findByText(/^expressive size-xl$/).should('be.visible');
    cy.findByText(/^secondary$/).should('be.visible');
    cy.findByText(/^tertiary$/).should('be.visible');
    cy.findByText(/^ghost$/).should('be.visible');
    cy.findByText(/^danger$/).should('be.visible');
    cy.findByText(/^danger--tertiary$/).should('be.visible');
    cy.findByText(/^danger--ghost$/).should('be.visible');
    cy.findByTestId('icon-only').should('be.visible'); // snapshots should always be taken _after_ an assertion that
    // a element/component should be visible. This is to ensure
    // the DOM has settled and the element has fully loaded.

    cy.percySnapshot();
  });
});