import _extends from "@babel/runtime/helpers/extends";

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import React from 'react';
import { action } from '@storybook/addon-actions';
import { Delete16 as Delete, Save16 as Save, Download16 as Download } from '@carbon/icons-react';
import Button from '../../Button';
import DataTable, { Table, TableBatchAction, TableBatchActions, TableBody, TableCell, TableContainer, TableHead, TableHeader, TableRow, TableSelectAll, TableSelectRow, TableToolbar, TableToolbarAction, TableToolbarContent, TableToolbarSearch, TableToolbarMenu } from '../../DataTable';
import { batchActionClick, rows, headers } from './shared';
import mdx from '../DataTable.mdx';
export default {
  title: 'Components/DataTable/Batch Actions',
  component: DataTable,
  subcomponents: {
    TableBatchAction: TableBatchAction,
    TableBatchActions: TableBatchActions,
    TableToolbar: TableToolbar,
    TableToolbarAction: TableToolbarAction,
    TableToolbarContent: TableToolbarContent,
    TableToolbarSearch: TableToolbarSearch,
    TableToolbarMenu: TableToolbarMenu,
    Table: Table,
    TableBody: TableBody,
    TableCell: TableCell,
    TableContainer: TableContainer,
    TableHead: TableHead,
    TableHeader: TableHeader,
    TableRow: TableRow
  },
  parameters: {
    docs: {
      page: mdx
    }
  }
};
export var Usage = function Usage() {
  return /*#__PURE__*/React.createElement(DataTable, {
    rows: rows,
    headers: headers
  }, function (_ref) {
    var rows = _ref.rows,
        headers = _ref.headers,
        getHeaderProps = _ref.getHeaderProps,
        getRowProps = _ref.getRowProps,
        getSelectionProps = _ref.getSelectionProps,
        getToolbarProps = _ref.getToolbarProps,
        getBatchActionProps = _ref.getBatchActionProps,
        onInputChange = _ref.onInputChange,
        selectedRows = _ref.selectedRows,
        getTableProps = _ref.getTableProps,
        getTableContainerProps = _ref.getTableContainerProps;
    var batchActionProps = getBatchActionProps();
    return /*#__PURE__*/React.createElement(TableContainer, _extends({
      title: "DataTable",
      description: "With batch actions"
    }, getTableContainerProps()), /*#__PURE__*/React.createElement(TableToolbar, getToolbarProps(), /*#__PURE__*/React.createElement(TableBatchActions, batchActionProps, /*#__PURE__*/React.createElement(TableBatchAction, {
      tabIndex: batchActionProps.shouldShowBatchActions ? 0 : -1,
      renderIcon: Delete,
      onClick: batchActionClick(selectedRows)
    }, "Delete"), /*#__PURE__*/React.createElement(TableBatchAction, {
      tabIndex: batchActionProps.shouldShowBatchActions ? 0 : -1,
      renderIcon: Save,
      onClick: batchActionClick(selectedRows)
    }, "Save"), /*#__PURE__*/React.createElement(TableBatchAction, {
      tabIndex: batchActionProps.shouldShowBatchActions ? 0 : -1,
      renderIcon: Download,
      onClick: batchActionClick(selectedRows)
    }, "Download")), /*#__PURE__*/React.createElement(TableToolbarContent, {
      "aria-hidden": batchActionProps.shouldShowBatchActions
    }, /*#__PURE__*/React.createElement(TableToolbarSearch, {
      persistent: "true",
      tabIndex: batchActionProps.shouldShowBatchActions ? -1 : 0,
      onChange: onInputChange
    }), /*#__PURE__*/React.createElement(TableToolbarMenu, {
      tabIndex: batchActionProps.shouldShowBatchActions ? -1 : 0
    }, /*#__PURE__*/React.createElement(TableToolbarAction, {
      onClick: function onClick() {
        return alert('Alert 1');
      }
    }, "Action 1"), /*#__PURE__*/React.createElement(TableToolbarAction, {
      onClick: function onClick() {
        return alert('Alert 2');
      }
    }, "Action 2"), /*#__PURE__*/React.createElement(TableToolbarAction, {
      onClick: function onClick() {
        return alert('Alert 3');
      }
    }, "Action 3")), /*#__PURE__*/React.createElement(Button, {
      tabIndex: batchActionProps.shouldShowBatchActions ? -1 : 0,
      onClick: action('Add new row'),
      size: "small",
      kind: "primary"
    }, "Add new"))), /*#__PURE__*/React.createElement(Table, getTableProps(), /*#__PURE__*/React.createElement(TableHead, null, /*#__PURE__*/React.createElement(TableRow, null, /*#__PURE__*/React.createElement(TableSelectAll, getSelectionProps()), headers.map(function (header, i) {
      return /*#__PURE__*/React.createElement(TableHeader, _extends({
        key: i
      }, getHeaderProps({
        header: header
      })), header.header);
    }))), /*#__PURE__*/React.createElement(TableBody, null, rows.map(function (row, i) {
      return /*#__PURE__*/React.createElement(TableRow, _extends({
        key: i
      }, getRowProps({
        row: row
      })), /*#__PURE__*/React.createElement(TableSelectRow, getSelectionProps({
        row: row
      })), row.cells.map(function (cell) {
        return /*#__PURE__*/React.createElement(TableCell, {
          key: cell.id
        }, cell.value);
      }));
    }))));
  });
};