/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import { FeatureFlags } from '../../FeatureFlags';
import { ActionableNotification, ToastNotification, InlineNotification } from '../';
import React from 'react';
import { action } from '@storybook/addon-actions';
export default {
  title: 'Components/Notifications',
  decorators: [function (Story) {
    return /*#__PURE__*/React.createElement(FeatureFlags, {
      flags: {
        'enable-v11-release': true
      }
    }, /*#__PURE__*/React.createElement(Story, null));
  }],
  argTypes: {
    kind: {
      options: ['error', 'info', 'info-square', 'success', 'warning', 'warning-alt'],
      control: {
        type: 'select'
      }
    },
    className: {
      control: {
        type: 'text'
      }
    }
  },
  args: {
    kind: 'error',
    children: 'Notification content',
    lowContrast: false,
    closeOnEscape: false,
    hideCloseButton: false,
    iconDescription: 'closes notification',
    statusIconDescription: 'notification',
    onClose: action('onClose'),
    onCloseButtonClick: action('onCloseButtonClick')
  }
};
export var Toast = function Toast(args) {
  return /*#__PURE__*/React.createElement(ToastNotification, args);
};
Toast.argTypes = {
  role: {
    options: ['alert', 'log', 'status'],
    control: {
      type: 'select'
    }
  }
};
Toast.args = {
  role: 'status',
  timeout: 0
};
export var Inline = function Inline(args) {
  return /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(InlineNotification, args), /*#__PURE__*/React.createElement(InlineNotification, args), /*#__PURE__*/React.createElement(InlineNotification, args));
};
Inline.argTypes = {
  role: {
    options: ['alert', 'log', 'status'],
    control: {
      type: 'select'
    }
  }
};
Inline.args = {
  role: 'status'
};
export var Actionable = function Actionable(args) {
  return /*#__PURE__*/React.createElement(ActionableNotification, args);
};
Actionable.args = {
  actionButtonLabel: 'Action',
  inline: false
};