import _extends from "@babel/runtime/helpers/extends";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["align", "as", "caret", "className", "children", "dropShadow", "highContrast", "light", "open"],
    _excluded2 = ["className", "children"];

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import cx from 'classnames';
import PropTypes from 'prop-types';
import React from 'react';
import { usePrefix } from '../../internal/usePrefix';
var Popover = /*#__PURE__*/React.forwardRef(function Popover(props, ref) {
  var _cx;

  var _props$align = props.align,
      align = _props$align === void 0 ? 'bottom' : _props$align,
      _props$as = props.as,
      BaseComponent = _props$as === void 0 ? 'span' : _props$as,
      _props$caret = props.caret,
      caret = _props$caret === void 0 ? true : _props$caret,
      customClassName = props.className,
      children = props.children,
      _props$dropShadow = props.dropShadow,
      dropShadow = _props$dropShadow === void 0 ? true : _props$dropShadow,
      _props$highContrast = props.highContrast,
      highContrast = _props$highContrast === void 0 ? false : _props$highContrast,
      _props$light = props.light,
      light = _props$light === void 0 ? false : _props$light,
      open = props.open,
      rest = _objectWithoutProperties(props, _excluded);

  var prefix = usePrefix();
  var className = cx((_cx = {}, _defineProperty(_cx, "".concat(prefix, "--popover-container"), true), _defineProperty(_cx, "".concat(prefix, "--popover--caret"), caret), _defineProperty(_cx, "".concat(prefix, "--popover--drop-shadow"), dropShadow), _defineProperty(_cx, "".concat(prefix, "--popover--high-contrast"), highContrast), _defineProperty(_cx, "".concat(prefix, "--popover--light"), light), _defineProperty(_cx, "".concat(prefix, "--popover--open"), open), _defineProperty(_cx, "".concat(prefix, "--popover--").concat(align), true), _defineProperty(_cx, customClassName, !!customClassName), _cx));
  return /*#__PURE__*/React.createElement(BaseComponent, _extends({}, rest, {
    className: className,
    ref: ref
  }), children);
});
Popover.propTypes = {
  /**
   * Specify how the popover should align with the trigger element
   */
  align: PropTypes.oneOf(['top', 'top-left', 'top-right', 'bottom', 'bottom-left', 'bottom-right', 'left', 'left-bottom', 'left-top', 'right', 'right-bottom', 'right-top']),

  /**
   * Provide a custom element or component to render the top-level node for the
   * component.
   */
  as: PropTypes.oneOfType([PropTypes.string, PropTypes.elementType]),

  /**
   * Specify whether a caret should be rendered
   */
  caret: PropTypes.bool,

  /**
   * Provide elements to be rendered inside of the component
   */
  children: PropTypes.node,

  /**
   * Provide a custom class name to be added to the outermost node in the
   * component
   */
  className: PropTypes.string,

  /**
   * Specify whether a drop shadow should be rendered on the popover
   */
  dropShadow: PropTypes.bool,

  /**
   * Render the component using the high-contrast variant
   */
  highContrast: PropTypes.bool,

  /**
   * Render the component using the light variant
   */
  light: PropTypes.bool,

  /**
   * Specify whether the component is currently open or closed
   */
  open: PropTypes.bool.isRequired
};
var PopoverContent = /*#__PURE__*/React.forwardRef(function PopoverContent(_ref, ref) {
  var className = _ref.className,
      children = _ref.children,
      rest = _objectWithoutProperties(_ref, _excluded2);

  var prefix = usePrefix();
  return /*#__PURE__*/React.createElement("span", _extends({}, rest, {
    className: "".concat(prefix, "--popover")
  }), /*#__PURE__*/React.createElement("span", {
    className: cx("".concat(prefix, "--popover-content"), className),
    ref: ref
  }, children), /*#__PURE__*/React.createElement("span", {
    className: "".concat(prefix, "--popover-caret")
  }));
});
PopoverContent.propTypes = {
  /**
   * Provide elements to be rendered inside of the component
   */
  children: PropTypes.node,

  /**
   * Provide a custom class name to be added to the outermost node in the
   * component
   */
  className: PropTypes.string
};
export { Popover, PopoverContent };