import _extends from "@babel/runtime/helpers/extends";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["className"];

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import PropTypes from 'prop-types';
import React from 'react';
import cx from 'classnames';
import { usePrefix } from '../../internal/usePrefix';

function Step() {
  var prefix = usePrefix();
  return /*#__PURE__*/React.createElement("li", {
    className: "".concat(prefix, "--progress-step ").concat(prefix, "--progress-step--incomplete")
  }, /*#__PURE__*/React.createElement("div", {
    className: "".concat(prefix, "--progress-step-button ").concat(prefix, "--progress-step-button--unclickable")
  }, /*#__PURE__*/React.createElement("svg", null, /*#__PURE__*/React.createElement("path", {
    d: "M 7, 7 m -7, 0 a 7,7 0 1,0 14,0 a 7,7 0 1,0 -14,0"
  })), /*#__PURE__*/React.createElement("p", {
    className: "".concat(prefix, "--progress-label")
  }), /*#__PURE__*/React.createElement("span", {
    className: "".concat(prefix, "--progress-line")
  })));
}

function ProgressIndicatorSkeleton(_ref) {
  var className = _ref.className,
      rest = _objectWithoutProperties(_ref, _excluded);

  var prefix = usePrefix();
  return /*#__PURE__*/React.createElement("ul", _extends({
    className: cx("".concat(prefix, "--progress"), "".concat(prefix, "--skeleton"), className)
  }, rest), /*#__PURE__*/React.createElement(Step, null), /*#__PURE__*/React.createElement(Step, null), /*#__PURE__*/React.createElement(Step, null), /*#__PURE__*/React.createElement(Step, null));
}

ProgressIndicatorSkeleton.propTypes = {
  /**
   * Specify an optional className to add.
   */
  className: PropTypes.string
};
export default ProgressIndicatorSkeleton;