/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import { Search, ExpandableSearch } from 'carbon-components-react';
import React from 'react';
import { Layer } from '../../Layer';
export default {
  title: 'Components/Search'
};
export var Default = function Default() {
  return /*#__PURE__*/React.createElement(Search, {
    size: "lg",
    defaultValue: "A default value",
    labelText: "Search",
    closeButtonLabelText: "Clear search input",
    id: "search-1",
    onChange: function onChange() {},
    onKeyDown: function onKeyDown() {}
  });
};
export var Disabled = function Disabled() {
  return /*#__PURE__*/React.createElement(Search, {
    disabled: true,
    size: "lg",
    defaultValue: "A default value",
    labelText: "Search",
    closeButtonLabelText: "Clear search input",
    id: "search-1",
    onChange: function onChange() {},
    onKeyDown: function onKeyDown() {}
  });
};
export var Expandable = function Expandable() {
  return /*#__PURE__*/React.createElement(ExpandableSearch, {
    size: "lg",
    labelText: "Search",
    closeButtonLabelText: "Clear search input",
    id: "search-expandable-1",
    onChange: function onChange() {},
    onKeyDown: function onKeyDown() {}
  });
};
export var withLayer = function withLayer() {
  return /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(Search, {
    size: "lg",
    defaultValue: "First Layer",
    labelText: "Search",
    closeButtonLabelText: "Clear search input",
    id: "search-1",
    onChange: function onChange() {},
    onKeyDown: function onKeyDown() {}
  }), /*#__PURE__*/React.createElement(Layer, null, /*#__PURE__*/React.createElement(Search, {
    size: "lg",
    defaultValue: "Second Layer",
    labelText: "Search",
    closeButtonLabelText: "Clear search input",
    id: "search-1",
    onChange: function onChange() {},
    onKeyDown: function onKeyDown() {}
  }), /*#__PURE__*/React.createElement(Layer, null, /*#__PURE__*/React.createElement(Search, {
    size: "lg",
    defaultValue: "Third Layer",
    labelText: "Search",
    closeButtonLabelText: "Clear search input",
    id: "search-1",
    onChange: function onChange() {},
    onKeyDown: function onKeyDown() {}
  }))));
};
export var ExpandableWithLayer = function ExpandableWithLayer() {
  return /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(ExpandableSearch, {
    size: "lg",
    labelText: "First Layer",
    closeButtonLabelText: "Clear search input",
    id: "search-expandable-1",
    onChange: function onChange() {},
    onKeyDown: function onKeyDown() {}
  }), /*#__PURE__*/React.createElement(Layer, null, /*#__PURE__*/React.createElement(ExpandableSearch, {
    size: "lg",
    labelText: "Second Layer",
    closeButtonLabelText: "Clear search input",
    id: "search-expandable-1",
    onChange: function onChange() {},
    onKeyDown: function onKeyDown() {}
  }), /*#__PURE__*/React.createElement(Layer, null, /*#__PURE__*/React.createElement(ExpandableSearch, {
    size: "lg",
    labelText: "Third Layer",
    closeButtonLabelText: "Clear search input",
    id: "search-expandable-1",
    onChange: function onChange() {},
    onKeyDown: function onKeyDown() {}
  }))));
};